/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import org.neo4j.kernel.impl.storageengine.impl.recordstorage.PropertyTraverser;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.transaction.state.RecordAccess;

public class PropertyDeleter {
    private final PropertyTraverser traverser;

    public PropertyDeleter(PropertyTraverser traverser) {
        this.traverser = traverser;
    }

    public void deletePropertyChain(PrimitiveRecord primitive, RecordAccess<PropertyRecord, PrimitiveRecord> propertyRecords) {
        long nextProp = primitive.getNextProp();
        while (nextProp != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            RecordAccess.RecordProxy<PropertyRecord, PrimitiveRecord> propertyChange = propertyRecords.getOrLoad(nextProp, primitive);
            PropertyRecord propRecord = propertyChange.forChangingData();
            PropertyDeleter.deletePropertyRecordIncludingValueRecords(propRecord);
            nextProp = propRecord.getNextProp();
            propRecord.setChanged(primitive);
        }
        primitive.setNextProp(Record.NO_NEXT_PROPERTY.intValue());
    }

    public static void deletePropertyRecordIncludingValueRecords(PropertyRecord record) {
        for (PropertyBlock block : record) {
            for (DynamicRecord valueRecord : block.getValueRecords()) {
                assert (valueRecord.inUse());
                valueRecord.setInUse(false);
                record.addDeletedRecord(valueRecord);
            }
        }
        record.clearPropertyBlocks();
        record.setInUse(false);
    }

    public <P extends PrimitiveRecord> boolean removePropertyIfExists(RecordAccess.RecordProxy<P, Void> primitiveProxy, int propertyKey, RecordAccess<PropertyRecord, PrimitiveRecord> propertyRecords) {
        PrimitiveRecord primitive = (PrimitiveRecord)primitiveProxy.forReadingData();
        long propertyId = this.traverser.findPropertyRecordContaining(primitive, propertyKey, propertyRecords, false);
        if (!Record.NO_NEXT_PROPERTY.is(propertyId)) {
            this.removeProperty(primitiveProxy, propertyKey, propertyRecords, primitive, propertyId);
            return true;
        }
        return false;
    }

    public <P extends PrimitiveRecord> void removeProperty(RecordAccess.RecordProxy<P, Void> primitiveProxy, int propertyKey, RecordAccess<PropertyRecord, PrimitiveRecord> propertyRecords) {
        PrimitiveRecord primitive = (PrimitiveRecord)primitiveProxy.forReadingData();
        long propertyId = this.traverser.findPropertyRecordContaining(primitive, propertyKey, propertyRecords, true);
        this.removeProperty(primitiveProxy, propertyKey, propertyRecords, primitive, propertyId);
    }

    private <P extends PrimitiveRecord> void removeProperty(RecordAccess.RecordProxy<P, Void> primitiveProxy, int propertyKey, RecordAccess<PropertyRecord, PrimitiveRecord> propertyRecords, PrimitiveRecord primitive, long propertyId) {
        RecordAccess.RecordProxy<PropertyRecord, PrimitiveRecord> recordChange = propertyRecords.getOrLoad(propertyId, primitive);
        PropertyRecord propRecord = recordChange.forChangingData();
        if (!propRecord.inUse()) {
            throw new IllegalStateException("Unable to delete property[" + propertyId + "] since it is already deleted.");
        }
        PropertyBlock block = propRecord.removePropertyBlock(propertyKey);
        if (block == null) {
            throw new IllegalStateException("Property with index[" + propertyKey + "] is not present in property[" + propertyId + "]");
        }
        for (DynamicRecord valueRecord : block.getValueRecords()) {
            assert (valueRecord.inUse());
            valueRecord.setInUse(false, block.getType().intValue());
            propRecord.addDeletedRecord(valueRecord);
        }
        if (propRecord.size() > 0) {
            propRecord.setChanged(primitive);
            assert (this.traverser.assertPropertyChain(primitive, propertyRecords));
        } else {
            this.unlinkPropertyRecord(propRecord, propertyRecords, primitiveProxy);
        }
    }

    private <P extends PrimitiveRecord> void unlinkPropertyRecord(PropertyRecord propRecord, RecordAccess<PropertyRecord, PrimitiveRecord> propertyRecords, RecordAccess.RecordProxy<P, Void> primitiveRecordChange) {
        PrimitiveRecord primitive = (PrimitiveRecord)primitiveRecordChange.forReadingLinkage();
        assert (this.traverser.assertPropertyChain(primitive, propertyRecords));
        assert (propRecord.size() == 0);
        long prevProp = propRecord.getPrevProp();
        long nextProp = propRecord.getNextProp();
        if (primitive.getNextProp() == propRecord.getId()) {
            assert (propRecord.getPrevProp() == (long)Record.NO_PREVIOUS_PROPERTY.intValue()) : propRecord + " for " + primitive;
            ((PrimitiveRecord)primitiveRecordChange.forChangingLinkage()).setNextProp(nextProp);
        }
        if (prevProp != (long)Record.NO_PREVIOUS_PROPERTY.intValue()) {
            PropertyRecord prevPropRecord = propertyRecords.getOrLoad(prevProp, primitive).forChangingLinkage();
            assert (prevPropRecord.inUse()) : prevPropRecord + "->" + propRecord + " for " + primitive;
            prevPropRecord.setNextProp(nextProp);
            prevPropRecord.setChanged(primitive);
        }
        if (nextProp != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            PropertyRecord nextPropRecord = propertyRecords.getOrLoad(nextProp, primitive).forChangingLinkage();
            assert (nextPropRecord.inUse()) : propRecord + "->" + nextPropRecord + " for " + primitive;
            nextPropRecord.setPrevProp(prevProp);
            nextPropRecord.setChanged(primitive);
        }
        propRecord.setInUse(false);
        propRecord.setPrevProp(Record.NO_PREVIOUS_PROPERTY.intValue());
        propRecord.setNextProp(Record.NO_NEXT_PROPERTY.intValue());
        propRecord.setChanged(primitive);
        assert (this.traverser.assertPropertyChain(primitive, propertyRecords));
    }
}

