/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.helpers.Format;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.PageCachedNumberArrayFactory;

public class PageCacheArrayFactoryMonitor
implements NumberArrayFactory.Monitor {
    private final AtomicReference<String> failedFactoriesDescription = new AtomicReference();

    @Override
    public void allocationSuccessful(long memory, NumberArrayFactory successfulFactory, Iterable<NumberArrayFactory.AllocationFailure> attemptedAllocationFailures) {
        if (successfulFactory instanceof PageCachedNumberArrayFactory) {
            StringBuilder builder = new StringBuilder(String.format("Memory allocation of %s ended up in page cache, which may impact performance negatively", Format.bytes(memory)));
            attemptedAllocationFailures.forEach(failure -> builder.append(String.format("%n%s: %s", failure.getFactory(), failure.getFailure())));
            this.failedFactoriesDescription.compareAndSet(null, builder.toString());
        }
    }

    public String pageCacheAllocationOrNull() {
        String failure = this.failedFactoriesDescription.get();
        if (failure != null) {
            this.failedFactoriesDescription.compareAndSet(failure, null);
        }
        return failure;
    }
}

