/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.diagnostics;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.diagnostics.DiagnosticsReportSource;
import org.neo4j.logging.RotatingFileOutputStreamSupplier;

public final class DiagnosticsReportSources {
    private DiagnosticsReportSources() {
    }

    public static DiagnosticsReportSource newDiagnosticsFile(String destination, FileSystemAbstraction fs, File source) {
        return new DiagnosticsFileReportSource(destination, fs, source);
    }

    public static List<DiagnosticsReportSource> newDiagnosticsRotatingFile(String destination, FileSystemAbstraction fs, File file) {
        ArrayList<DiagnosticsReportSource> files = new ArrayList<DiagnosticsReportSource>();
        files.add(DiagnosticsReportSources.newDiagnosticsFile(destination, fs, file));
        List allArchives = RotatingFileOutputStreamSupplier.getAllArchives((FileSystemAbstraction)fs, (File)file);
        for (File archive : allArchives) {
            String name = archive.getName();
            String n = name.substring(name.lastIndexOf(46));
            files.add(DiagnosticsReportSources.newDiagnosticsFile(destination + "." + n, fs, archive));
        }
        return files;
    }

    public static DiagnosticsReportSource newDiagnosticsString(String destination, Supplier<String> messageSupplier) {
        return new DiagnosticsStringReportSource(destination, messageSupplier);
    }

    private static class DiagnosticsStringReportSource
    implements DiagnosticsReportSource {
        private final String destination;
        private final Supplier<String> messageSupplier;

        private DiagnosticsStringReportSource(String destination, Supplier<String> messageSupplier) {
            this.destination = destination;
            this.messageSupplier = messageSupplier;
        }

        @Override
        public String destinationPath() {
            return this.destination;
        }

        @Override
        public InputStream newInputStream() {
            String message = this.messageSupplier.get();
            return new ByteArrayInputStream(message.getBytes(StandardCharsets.UTF_8));
        }

        @Override
        public long estimatedSize() {
            return 0L;
        }
    }

    private static class DiagnosticsFileReportSource
    implements DiagnosticsReportSource {
        private final String destination;
        private final FileSystemAbstraction fs;
        private final File source;

        DiagnosticsFileReportSource(String destination, FileSystemAbstraction fs, File source) {
            this.destination = destination;
            this.fs = fs;
            this.source = source;
        }

        @Override
        public String destinationPath() {
            return this.destination;
        }

        @Override
        public InputStream newInputStream() throws IOException {
            return this.fs.openAsInputStream(this.source);
        }

        @Override
        public long estimatedSize() {
            return this.fs.getFileSize(this.source);
        }
    }
}

