/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.File;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.index.MinimalIndexAccessor;
import org.neo4j.kernel.impl.api.index.AbstractSwallowingIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.values.storable.Value;

public class FailedIndexProxy
extends AbstractSwallowingIndexProxy {
    private final MinimalIndexAccessor minimalIndexAccessor;
    private final String indexUserDescription;
    private final IndexStatisticsStore indexStatisticsStore;
    private final Log log;

    FailedIndexProxy(IndexDescriptor descriptor, String indexUserDescription, MinimalIndexAccessor minimalIndexAccessor, IndexPopulationFailure populationFailure, IndexStatisticsStore indexStatisticsStore, LogProvider logProvider) {
        super(descriptor, populationFailure);
        this.minimalIndexAccessor = minimalIndexAccessor;
        this.indexUserDescription = indexUserDescription;
        this.indexStatisticsStore = indexStatisticsStore;
        this.log = logProvider.getLog(this.getClass());
    }

    @Override
    public void start() {
    }

    public void drop() {
        this.indexStatisticsStore.removeIndex(this.getDescriptor().getId());
        String message = "FailedIndexProxy#drop index on " + this.indexUserDescription + " dropped due to:\n" + this.getPopulationFailure().asString();
        this.log.info(message);
        this.minimalIndexAccessor.drop();
    }

    @Override
    public InternalIndexState getState() {
        return InternalIndexState.FAILED;
    }

    @Override
    public boolean awaitStoreScanCompleted(long time, TimeUnit unit) throws IndexPopulationFailedKernelException {
        throw this.failureCause();
    }

    private IndexPopulationFailedKernelException failureCause() {
        return this.getPopulationFailure().asIndexPopulationFailure(this.getDescriptor().schema(), this.indexUserDescription);
    }

    @Override
    public void activate() {
        throw new UnsupportedOperationException("Cannot activate a failed index.");
    }

    @Override
    public void validate() throws IndexPopulationFailedKernelException {
        throw this.failureCause();
    }

    @Override
    public void validateBeforeCommit(Value[] tuple, long entityId) {
    }

    @Override
    public ResourceIterator<File> snapshotFiles() {
        return Iterators.emptyResourceIterator();
    }

    public Map<String, Value> indexConfig() {
        return this.minimalIndexAccessor.indexConfig();
    }
}

