/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import org.neo4j.internal.kernel.api.AutoCloseablePlus;
import org.neo4j.util.FeatureToggles;

abstract class DefaultCursors {
    private static final boolean DEBUG_CLOSING = FeatureToggles.flag(DefaultCursors.class, (String)"trackCursors", (boolean)false);
    private final Collection<CloseableStacktrace> closeables;

    DefaultCursors(Collection<CloseableStacktrace> closeables) {
        this.closeables = closeables;
    }

    protected <T extends AutoCloseablePlus> T trace(T closeable) {
        if (DEBUG_CLOSING) {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            this.closeables.add(new CloseableStacktrace(closeable, Arrays.copyOfRange(stackTrace, 2, stackTrace.length)));
        }
        return closeable;
    }

    void assertClosed() {
        if (DEBUG_CLOSING) {
            for (CloseableStacktrace c : this.closeables) {
                c.assertClosed();
            }
            this.closeables.clear();
        }
    }

    static class CloseableStacktrace {
        private final AutoCloseablePlus c;
        private final StackTraceElement[] stackTrace;

        CloseableStacktrace(AutoCloseablePlus c, StackTraceElement[] stackTrace) {
            this.c = c;
            this.stackTrace = stackTrace;
        }

        void assertClosed() {
            if (!this.c.isClosed()) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                PrintStream printStream = new PrintStream((OutputStream)out, false, StandardCharsets.UTF_8);
                for (StackTraceElement traceElement : this.stackTrace) {
                    printStream.println("\tat " + traceElement);
                }
                printStream.println();
                throw new IllegalStateException(String.format("Closeable %s was not closed!%n%s", this.c, out.toString(StandardCharsets.UTF_8)));
            }
        }
    }
}

