/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files.checkpoint;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckpointAppender;
import org.neo4j.kernel.impl.transaction.log.files.LogTailInformation;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFiles;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesContext;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointInfo;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointLogFile;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.LegacyCheckpointLogFile;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class CompositeCheckpointLogFile
extends LifecycleAdapter
implements CheckpointFile {
    private final CheckpointLogFile checkpointLogFile;
    private final LegacyCheckpointLogFile legacyCheckpointLogFile;

    public CompositeCheckpointLogFile(TransactionLogFiles logFiles, TransactionLogFilesContext context) {
        this.checkpointLogFile = new CheckpointLogFile(logFiles, context);
        this.legacyCheckpointLogFile = new LegacyCheckpointLogFile(logFiles, context);
    }

    public void start() throws Exception {
        this.checkpointLogFile.start();
    }

    public void shutdown() throws Exception {
        this.checkpointLogFile.shutdown();
    }

    @Override
    public Optional<CheckpointInfo> findLatestCheckpoint() throws IOException {
        Optional<CheckpointInfo> latestCheckpoint = this.checkpointLogFile.findLatestCheckpoint();
        if (latestCheckpoint.isEmpty()) {
            latestCheckpoint = this.legacyCheckpointLogFile.findLatestCheckpoint();
        }
        return latestCheckpoint;
    }

    @Override
    public List<CheckpointInfo> reachableCheckpoints() throws IOException {
        List<CheckpointInfo> checkpointInfos = this.checkpointLogFile.reachableCheckpoints();
        List<CheckpointInfo> legacyCheckpointInfos = this.legacyCheckpointLogFile.reachableCheckpoints();
        legacyCheckpointInfos.addAll(checkpointInfos);
        return legacyCheckpointInfos;
    }

    @Override
    public List<CheckpointInfo> getReachableDetachedCheckpoints() throws IOException {
        return this.checkpointLogFile.getReachableDetachedCheckpoints();
    }

    @Override
    public CheckpointAppender getCheckpointAppender() {
        return this.checkpointLogFile.getCheckpointAppender();
    }

    @Override
    public LogTailInformation getTailInformation() {
        LogTailInformation tailInformation = this.checkpointLogFile.getTailInformation();
        if (tailInformation.lastCheckPoint == null) {
            tailInformation = this.legacyCheckpointLogFile.getTailInformation();
        }
        return tailInformation;
    }

    @Override
    public Path getCurrentFile() {
        return this.checkpointLogFile.getCurrentFile();
    }

    @Override
    public Path getDetachedCheckpointFileForVersion(long logVersion) {
        return this.checkpointLogFile.getDetachedCheckpointFileForVersion(logVersion);
    }

    @Override
    public Path[] getDetachedCheckpointFiles() {
        return this.checkpointLogFile.getDetachedCheckpointFiles();
    }

    @Override
    public long getCurrentDetachedLogVersion() {
        return this.checkpointLogFile.getCurrentDetachedLogVersion();
    }

    @Override
    public long getDetachedCheckpointLogFileVersion(Path checkpointLogFile) {
        return this.checkpointLogFile.getDetachedCheckpointLogFileVersion(checkpointLogFile);
    }

    @Override
    public boolean rotationNeeded() {
        return this.checkpointLogFile.rotationNeeded();
    }

    @Override
    public synchronized Path rotate() throws IOException {
        return this.checkpointLogFile.rotate();
    }

    @Override
    public long getLowestLogVersion() {
        return this.checkpointLogFile.getLowestLogVersion();
    }

    @Override
    public long getHighestLogVersion() {
        return this.checkpointLogFile.getHighestLogVersion();
    }
}

