/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files.checkpoint;

import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import org.neo4j.kernel.impl.transaction.log.LogEntryCursor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryInlinedCheckPoint;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogTailInformation;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesContext;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.AbstractLogTailScanner;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointInfo;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.Monitors;
import org.neo4j.storageengine.api.StoreId;

public class InlinedLogTailScanner
extends AbstractLogTailScanner {
    private final boolean failOnCorruptedLogFiles;

    InlinedLogTailScanner(LogFiles logFiles, LogEntryReader logEntryReader, Monitors monitors, boolean failOnCorruptedLogFiles, MemoryTracker memoryTracker) {
        this(logFiles, logEntryReader, monitors, failOnCorruptedLogFiles, (LogProvider)NullLogProvider.getInstance(), memoryTracker);
    }

    InlinedLogTailScanner(LogFiles logFiles, LogEntryReader logEntryReader, Monitors monitors, boolean failOnCorruptedLogFiles, LogProvider log, MemoryTracker memoryTracker) {
        super(logFiles, logEntryReader, monitors, log, memoryTracker);
        this.failOnCorruptedLogFiles = failOnCorruptedLogFiles;
    }

    InlinedLogTailScanner(LogFiles logFiles, TransactionLogFilesContext context) {
        this(logFiles, context.getLogEntryReader(), context.getMonitors(), context.isFailOnCorruptedLogFiles(), context.getLogProvider(), context.getMemoryTracker());
    }

    @Override
    protected LogTailInformation findLogTail() throws IOException {
        long highestLogVersion;
        LogFile logFile = this.logFiles.getLogFile();
        long version = highestLogVersion = logFile.getHighestLogVersion();
        long versionToSearchForCommits = highestLogVersion;
        LogEntryStart latestStartEntry = null;
        long oldestStartEntryTransaction = -1L;
        long oldestVersionFound = -1L;
        byte latestLogEntryVersion = 0;
        boolean startRecordAfterCheckpoint = false;
        boolean corruptedTransactionLogs = false;
        while (version >= logFile.getLowestLogVersion() && version >= 0L) {
            this.log.info("Scanning log file with version %d for checkpoint entries", new Object[]{version});
            oldestVersionFound = version;
            CheckpointInfo latestCheckPoint = null;
            StoreId storeId = StoreId.UNKNOWN;
            try (PhysicalLogVersionedStoreChannel channel = logFile.openForVersion(version);
                 ReadAheadLogChannel readAheadChannel = new ReadAheadLogChannel(channel, this.memoryTracker);
                 LogEntryCursor cursor = new LogEntryCursor(this.logEntryReader, (ReadableClosablePositionAwareChecksumChannel)readAheadChannel);){
                LogHeader logHeader = logFile.extractHeader(version);
                storeId = logHeader.getStoreId();
                long position = logHeader.getStartPosition().getByteOffset();
                long channelVersion = version;
                while (cursor.next()) {
                    LogEntry entry = cursor.get();
                    if (entry instanceof LogEntryInlinedCheckPoint) {
                        latestCheckPoint = new CheckpointInfo((LogEntryInlinedCheckPoint)entry, storeId, new LogPosition(channelVersion, position));
                    } else if (entry instanceof LogEntryCommit) {
                        if (oldestStartEntryTransaction == -1L) {
                            oldestStartEntryTransaction = ((LogEntryCommit)entry).getTxId();
                        }
                    } else if (entry instanceof LogEntryStart) {
                        LogEntryStart startEntry = (LogEntryStart)entry;
                        if (version == versionToSearchForCommits) {
                            latestStartEntry = startEntry;
                        }
                        startRecordAfterCheckpoint = true;
                    }
                    if (version == versionToSearchForCommits || latestLogEntryVersion == 0) {
                        latestLogEntryVersion = entry.getVersion();
                    }
                    position = channel.position();
                    channelVersion = channel.getVersion();
                }
                this.verifyReaderPosition(version, this.logEntryReader.lastPosition());
            }
            catch (Error | ClosedByInterruptException e) {
                throw e;
            }
            catch (Throwable t) {
                this.monitor.corruptedLogFile(version, t);
                if (this.failOnCorruptedLogFiles) {
                    InlinedLogTailScanner.throwUnableToCleanRecover(t);
                }
                corruptedTransactionLogs = true;
            }
            if (latestCheckPoint != null) {
                return this.checkpointTailInformation(highestLogVersion, latestStartEntry, oldestVersionFound, latestLogEntryVersion, latestCheckPoint, corruptedTransactionLogs, storeId);
            }
            --version;
            if (latestStartEntry != null) continue;
            --versionToSearchForCommits;
        }
        return new LogTailInformation(corruptedTransactionLogs || startRecordAfterCheckpoint, oldestStartEntryTransaction, oldestVersionFound == -1L, highestLogVersion, latestLogEntryVersion);
    }
}

