/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexValueValidator;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.values.AnyValue;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueCategory;

class GenericIndexKeyValidator
implements IndexValueValidator {
    private final IndexDescriptor descriptor;
    private final int maxLength;
    private final Layout<GenericKey, NativeIndexValue> layout;
    private final TokenNameLookup tokenNameLookup;

    GenericIndexKeyValidator(int maxLength, IndexDescriptor descriptor, Layout<GenericKey, NativeIndexValue> layout, TokenNameLookup tokenNameLookup) {
        this.maxLength = maxLength;
        this.descriptor = descriptor;
        this.layout = layout;
        this.tokenNameLookup = tokenNameLookup;
    }

    public void validate(long entityId, Value ... values) {
        int size;
        int worstCaseSize = GenericIndexKeyValidator.worstCaseLength(values);
        if (worstCaseSize > this.maxLength && (size = this.actualLength(values)) > this.maxLength) {
            IndexValueValidator.throwSizeViolationException((IndexDescriptor)this.descriptor, (TokenNameLookup)this.tokenNameLookup, (long)entityId, (int)size, (Value[])values);
        }
    }

    private static int worstCaseLength(Value[] values) {
        int length = 8;
        for (Value value : values) {
            length += 8;
            length += GenericIndexKeyValidator.worstCaseLength((AnyValue)value);
        }
        return length;
    }

    private static int worstCaseLength(AnyValue value) {
        if (value.isSequenceValue()) {
            SequenceValue sequenceValue = (SequenceValue)value;
            if (sequenceValue instanceof TextArray) {
                TextArray textArray = (TextArray)sequenceValue;
                int length = 0;
                for (int i = 0; i < textArray.length(); ++i) {
                    length += GenericIndexKeyValidator.stringWorstCaseLength(textArray.stringValue(i).length());
                }
                return length;
            }
            return sequenceValue.length() * 32;
        }
        if (((Value)value).valueGroup().category() == ValueCategory.TEXT) {
            return GenericIndexKeyValidator.stringWorstCaseLength(((TextValue)value).length());
        }
        return 32;
    }

    private static int stringWorstCaseLength(int stringLength) {
        return 2 + stringLength * 4;
    }

    private int actualLength(Value[] values) {
        GenericKey key = (GenericKey)((Object)this.layout.newKey());
        key.initialize(0L);
        for (int i = 0; i < values.length; ++i) {
            key.initFromValue(i, values[i], NativeIndexKey.Inclusion.NEUTRAL);
        }
        return key.size();
    }
}

