/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.PopulationProgress;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.IOUtils;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.IndexValueValidator;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.api.index.updater.DelegatingIndexUpdater;
import org.neo4j.kernel.impl.index.schema.BlockStorage;
import org.neo4j.kernel.impl.index.schema.ConflictDetectingValueMerger;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.IndexKeyStorage;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.IndexUpdateCursor;
import org.neo4j.kernel.impl.index.schema.IndexUpdateStorage;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexPopulator;
import org.neo4j.kernel.impl.index.schema.NativeIndexUpdater;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.UpdateMode;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.util.Preconditions;
import org.neo4j.util.concurrent.Runnables;
import org.neo4j.values.storable.Value;

public abstract class BlockBasedIndexPopulator<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
extends NativeIndexPopulator<KEY, VALUE> {
    private final boolean archiveFailedIndex;
    private final MemoryTracker memoryTracker;
    private final int mergeFactor;
    private final BlockStorage.Monitor blockStorageMonitor;
    private final List<ThreadLocalBlockStorage> allScanUpdates = new CopyOnWriteArrayList<ThreadLocalBlockStorage>();
    private final ThreadLocal<ThreadLocalBlockStorage> scanUpdates;
    private final ByteBufferFactory bufferFactory;
    private IndexUpdateStorage<KEY, VALUE> externalUpdates;
    private volatile boolean scanCompleted;
    private final CloseCancellation cancellation = new CloseCancellation();
    private volatile CountDownLatch mergeOngoingLatch;
    private IndexSample nonUniqueIndexSample;
    private final AtomicLong numberOfIndexUpdatesSinceSample = new AtomicLong();
    private IndexValueValidator validator;
    private final AtomicLong numberOfAppliedScanUpdates = new AtomicLong();
    private final AtomicLong numberOfAppliedExternalUpdates = new AtomicLong();

    BlockBasedIndexPopulator(DatabaseIndexContext databaseIndexContext, IndexFiles indexFiles, IndexLayout<KEY, VALUE> layout, IndexDescriptor descriptor, boolean archiveFailedIndex, ByteBufferFactory bufferFactory, Config config, MemoryTracker memoryTracker) {
        this(databaseIndexContext, indexFiles, layout, descriptor, archiveFailedIndex, bufferFactory, config, memoryTracker, BlockStorage.Monitor.NO_MONITOR);
    }

    BlockBasedIndexPopulator(DatabaseIndexContext databaseIndexContext, IndexFiles indexFiles, IndexLayout<KEY, VALUE> layout, IndexDescriptor descriptor, boolean archiveFailedIndex, ByteBufferFactory bufferFactory, Config config, MemoryTracker memoryTracker, BlockStorage.Monitor blockStorageMonitor) {
        super(databaseIndexContext, indexFiles, layout, descriptor);
        this.archiveFailedIndex = archiveFailedIndex;
        this.memoryTracker = memoryTracker;
        this.mergeFactor = (Integer)config.get(GraphDatabaseInternalSettings.index_populator_merge_factor);
        this.blockStorageMonitor = blockStorageMonitor;
        this.scanUpdates = ThreadLocal.withInitial(this::newThreadLocalBlockStorage);
        this.bufferFactory = bufferFactory;
    }

    private synchronized ThreadLocalBlockStorage newThreadLocalBlockStorage() {
        Preconditions.checkState((!this.cancellation.cancelled() ? 1 : 0) != 0, (String)"Already closed");
        Preconditions.checkState((!this.scanCompleted ? 1 : 0) != 0, (String)"Scan has already been completed");
        try {
            int id = this.allScanUpdates.size();
            ThreadLocalBlockStorage blockStorage = new ThreadLocalBlockStorage(id);
            this.allScanUpdates.add(blockStorage);
            return blockStorage;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void create() throws IOException {
        if (this.archiveFailedIndex) {
            this.indexFiles.archiveIndex();
        }
        super.create();
        Path storeFile = this.indexFiles.getStoreFile();
        Path externalUpdatesFile = storeFile.resolveSibling(storeFile.getFileName() + ".ext");
        this.validator = this.instantiateValueValidator();
        this.externalUpdates = new IndexUpdateStorage(this.fileSystem, externalUpdatesFile, this.bufferFactory.globalAllocator(), this.smallerBufferSize(), this.layout, this.memoryTracker);
    }

    protected abstract IndexValueValidator instantiateValueValidator();

    private int smallerBufferSize() {
        return this.bufferFactory.bufferSize() / 2;
    }

    @Override
    public void add(Collection<? extends IndexEntryUpdate<?>> updates, CursorContext cursorContext) {
        if (!updates.isEmpty()) {
            BlockStorage blockStorage = this.scanUpdates.get().blockStorage;
            for (IndexEntryUpdate<?> update : updates) {
                this.storeUpdate((ValueIndexEntryUpdate)update, blockStorage);
            }
        }
    }

    private void storeUpdate(long entityId, Value[] values, BlockStorage<KEY, VALUE> blockStorage) {
        try {
            this.validator.validate(entityId, values);
            NativeIndexKey key = (NativeIndexKey)((Object)this.layout.newKey());
            Object value = this.layout.newValue();
            NativeIndexUpdater.initializeKeyFromUpdate(key, entityId, values);
            ((NativeIndexValue)value).from(values);
            blockStorage.add(key, value);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void storeUpdate(ValueIndexEntryUpdate<?> update, BlockStorage<KEY, VALUE> blockStorage) {
        this.storeUpdate(update.getEntityId(), update.values(), blockStorage);
    }

    private synchronized boolean markMergeStarted() {
        this.scanCompleted = true;
        if (this.cancellation.cancelled()) {
            return false;
        }
        this.mergeOngoingLatch = new CountDownLatch(1);
        return true;
    }

    public void scanCompleted(PhaseTracker phaseTracker, IndexPopulator.PopulationWorkScheduler populationWorkScheduler, CursorContext cursorContext) throws IndexEntryConflictException {
        if (!this.markMergeStarted()) {
            return;
        }
        try {
            block28: {
                phaseTracker.enterPhase(PhaseTracker.Phase.MERGE);
                if (!this.allScanUpdates.isEmpty()) {
                    this.mergeScanUpdates(populationWorkScheduler);
                }
                this.externalUpdates.doneAdding();
                if (this.cancellation.cancelled()) {
                    return;
                }
                phaseTracker.enterPhase(PhaseTracker.Phase.BUILD);
                Path storeFile = this.indexFiles.getStoreFile();
                Path duplicatesFile = storeFile.resolveSibling(storeFile.getFileName() + ".dup");
                int readBufferSize = this.smallerBufferSize();
                try (ByteBufferFactory.Allocator allocator = this.bufferFactory.newLocalAllocator();
                     IndexKeyStorage indexKeyStorage = new IndexKeyStorage(this.fileSystem, duplicatesFile, allocator, readBufferSize, this.layout, this.memoryTracker);){
                    RecordingConflictDetector recordingConflictDetector = new RecordingConflictDetector(!this.descriptor.isUnique(), indexKeyStorage);
                    this.nonUniqueIndexSample = this.writeScanUpdatesToTree(populationWorkScheduler, recordingConflictDetector, allocator, readBufferSize, cursorContext);
                    phaseTracker.enterPhase(PhaseTracker.Phase.APPLY_EXTERNAL);
                    this.writeExternalUpdatesToTree(recordingConflictDetector, cursorContext);
                    if (!this.descriptor.isUnique()) break block28;
                    try (IndexKeyStorage.KeyEntryCursor allConflictingKeys = recordingConflictDetector.allConflicts();){
                        this.verifyUniqueKeys(allConflictingKeys, cursorContext);
                    }
                }
            }
            this.flushTreeAndMarkAs((byte)2, cursorContext);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Got interrupted, so merge not completed", e);
        }
        catch (ExecutionException e) {
            Throwable executionException = e.getCause();
            Exceptions.throwIfUnchecked((Throwable)executionException);
            throw new RuntimeException(executionException);
        }
        finally {
            this.mergeOngoingLatch.countDown();
        }
    }

    private void mergeScanUpdates(IndexPopulator.PopulationWorkScheduler populationWorkScheduler) throws InterruptedException, ExecutionException, IOException {
        ArrayList<JobHandle> mergeFutures = new ArrayList<JobHandle>();
        for (ThreadLocalBlockStorage part : this.allScanUpdates) {
            BlockStorage scanUpdates = part.blockStorage;
            scanUpdates.doneAdding();
            mergeFutures.add(populationWorkScheduler.schedule(indexName -> "Block merging for '" + indexName + "'", () -> {
                scanUpdates.merge(this.mergeFactor, this.cancellation);
                return null;
            }));
        }
        for (JobHandle mergeFuture : mergeFutures) {
            mergeFuture.get();
        }
    }

    private void writeExternalUpdatesToTree(RecordingConflictDetector<KEY, VALUE> recordingConflictDetector, CursorContext cursorContext) throws IOException, IndexEntryConflictException {
        try (Writer writer = this.tree.writer(cursorContext);
             IndexUpdateCursor updates = (IndexUpdateCursor)this.externalUpdates.reader();){
            while (updates.next() && !this.cancellation.cancelled()) {
                switch (updates.updateMode()) {
                    case ADDED: {
                        this.writeToTree(writer, recordingConflictDetector, (NativeIndexKey)((Object)updates.key()), (NativeIndexValue)updates.value());
                        break;
                    }
                    case REMOVED: {
                        writer.remove((Object)((NativeIndexKey)((Object)updates.key())));
                        break;
                    }
                    case CHANGED: {
                        writer.remove((Object)((NativeIndexKey)((Object)updates.key())));
                        this.writeToTree(writer, recordingConflictDetector, (NativeIndexKey)((Object)updates.key2()), (NativeIndexValue)updates.value());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown update mode " + updates.updateMode());
                    }
                }
                this.numberOfAppliedExternalUpdates.incrementAndGet();
                this.numberOfIndexUpdatesSinceSample.incrementAndGet();
            }
        }
    }

    private void verifyUniqueKeys(IndexKeyStorage.KeyEntryCursor<KEY> allConflictingKeys, CursorContext cursorContext) throws IOException, IndexEntryConflictException {
        while (allConflictingKeys.next() && !this.cancellation.cancelled()) {
            NativeIndexKey key = (NativeIndexKey)((Object)allConflictingKeys.key());
            key.setCompareId(false);
            Seeker seeker = this.tree.seek((Object)key, (Object)key, cursorContext);
            try {
                this.verifyUniqueSeek(seeker);
            }
            finally {
                if (seeker == null) continue;
                seeker.close();
            }
        }
    }

    private void verifyUniqueSeek(Seeker<KEY, VALUE> seek) throws IOException, IndexEntryConflictException {
        if (seek != null && seek.next()) {
            NativeIndexKey key = (NativeIndexKey)((Object)seek.key());
            long firstEntityId = key.getEntityId();
            if (seek.next()) {
                long secondEntityId = key.getEntityId();
                throw new IndexEntryConflictException(firstEntityId, secondEntityId, key.asValues());
            }
        }
    }

    /*
     * Exception decompiling
     */
    private IndexSample writeScanUpdatesToTree(IndexPopulator.PopulationWorkScheduler populationWorkScheduler, RecordingConflictDetector<KEY, VALUE> recordingConflictDetector, ByteBufferFactory.Allocator allocator, int bufferSize, CursorContext cursorContext) throws IOException, IndexEntryConflictException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public IndexUpdater newPopulatingUpdater(CursorContext cursorContext) {
        if (this.scanCompleted) {
            return new DelegatingIndexUpdater(super.newPopulatingUpdater(cursorContext)){

                @Override
                public void process(IndexEntryUpdate<?> update) throws IndexEntryConflictException {
                    ValueIndexEntryUpdate valueUpdate = this.asValueUpdate(update);
                    BlockBasedIndexPopulator.this.validateUpdate(valueUpdate);
                    BlockBasedIndexPopulator.this.numberOfIndexUpdatesSinceSample.incrementAndGet();
                    super.process((IndexEntryUpdate<?>)valueUpdate);
                }
            };
        }
        return new IndexUpdater(){
            private volatile boolean closed;

            public void process(IndexEntryUpdate<?> update) {
                this.assertOpen();
                ValueIndexEntryUpdate valueUpdate = this.asValueUpdate(update);
                try {
                    BlockBasedIndexPopulator.this.validateUpdate(valueUpdate);
                    BlockBasedIndexPopulator.this.externalUpdates.add(valueUpdate);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            public void close() {
                this.closed = true;
            }

            private void assertOpen() {
                if (this.closed) {
                    throw new IllegalStateException("Updater has been closed");
                }
            }
        };
    }

    private void validateUpdate(ValueIndexEntryUpdate<?> update) {
        if (update.updateMode() != UpdateMode.REMOVED) {
            this.validator.validate(update.getEntityId(), update.values());
        }
    }

    @Override
    public synchronized void drop() {
        Runnables.runAll((String)"Failed while trying to drop index", (Runnable[])new Runnable[]{this::closeBlockStorage, () -> super.drop()});
    }

    @Override
    public synchronized void close(boolean populationCompletedSuccessfully, CursorContext cursorContext) {
        Runnables.runAll((String)"Failed while trying to close index", (Runnable[])new Runnable[]{this::closeBlockStorage, () -> super.close(populationCompletedSuccessfully, cursorContext)});
    }

    private void closeBlockStorage() {
        this.cancellation.setCancel();
        if (this.mergeOngoingLatch != null) {
            try {
                this.mergeOngoingLatch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        List toClose = this.allScanUpdates.stream().map(local -> local.blockStorage).collect(Collectors.toCollection(ArrayList::new));
        toClose.add(this.externalUpdates);
        IOUtils.closeAllUnchecked((Collection)toClose);
    }

    public PopulationProgress progress(PopulationProgress scanProgress) {
        PopulationProgress treeBuildProgress;
        PopulationProgress.MultiBuilder builder = PopulationProgress.multiple();
        builder.add(scanProgress, 4.0f);
        if (!this.allScanUpdates.isEmpty()) {
            long completed = 0L;
            long total = 0L;
            if (this.scanCompleted) {
                ThreadLocalBlockStorage part2 = (ThreadLocalBlockStorage)Iterables.first(this.allScanUpdates);
                completed = part2.entriesMerged.get();
                total = part2.totalEntriesToMerge;
            }
            builder.add(PopulationProgress.single((long)completed, (long)total), 1.0f);
        }
        if (this.allScanUpdates.stream().allMatch(part -> part.mergeStarted)) {
            long entryCount = this.allScanUpdates.stream().mapToLong(part -> part.count).sum() + this.externalUpdates.count();
            treeBuildProgress = PopulationProgress.single((long)(this.numberOfAppliedScanUpdates.get() + this.numberOfAppliedExternalUpdates.get()), (long)entryCount);
        } else {
            treeBuildProgress = PopulationProgress.NONE;
        }
        builder.add(treeBuildProgress, 2.0f);
        return builder.build();
    }

    private void writeToTree(Writer<KEY, VALUE> writer, RecordingConflictDetector<KEY, VALUE> recordingConflictDetector, KEY key, VALUE value) throws IndexEntryConflictException {
        recordingConflictDetector.controlConflictDetection(key);
        writer.merge(key, value, recordingConflictDetector);
        this.handleMergeConflict(writer, recordingConflictDetector, key, value);
    }

    private void handleMergeConflict(Writer<KEY, VALUE> writer, RecordingConflictDetector<KEY, VALUE> recordingConflictDetector, KEY key, VALUE value) throws IndexEntryConflictException {
        if (recordingConflictDetector.wasConflicting()) {
            NativeIndexKey copy = (NativeIndexKey)((Object)this.layout.newKey());
            this.layout.copyKey(key, (Object)copy);
            recordingConflictDetector.reportConflict(copy);
            recordingConflictDetector.relaxUniqueness(key);
            writer.put(key, value);
        }
    }

    @Override
    IndexSample buildNonUniqueIndexSample(CursorContext cursorContext) {
        return new IndexSample(this.nonUniqueIndexSample.indexSize(), this.nonUniqueIndexSample.uniqueValues(), this.nonUniqueIndexSample.sampleSize(), this.numberOfIndexUpdatesSinceSample.get());
    }

    private static class CompositeBuffer
    implements AutoCloseable {
        private final Collection<AutoCloseable> buffers = new ArrayList<AutoCloseable>();

        private CompositeBuffer() {
        }

        public void addBuffer(AutoCloseable buffer) {
            this.buffers.add(buffer);
        }

        @Override
        public void close() {
            IOUtils.closeAllUnchecked(this.buffers);
        }
    }

    private static class RecordingConflictDetector<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
    extends ConflictDetectingValueMerger<KEY, VALUE, KEY> {
        private final IndexKeyStorage<KEY> allConflictingKeys;

        RecordingConflictDetector(boolean compareEntityIds, IndexKeyStorage<KEY> indexKeyStorage) {
            super(compareEntityIds);
            this.allConflictingKeys = indexKeyStorage;
        }

        @Override
        void doReportConflict(long existingNodeId, long addedNodeId, KEY conflictingKey) {
            try {
                this.allConflictingKeys.add(conflictingKey);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        IndexKeyStorage.KeyEntryCursor<KEY> allConflicts() throws IOException {
            this.allConflictingKeys.doneAdding();
            return (IndexKeyStorage.KeyEntryCursor)this.allConflictingKeys.reader();
        }

        void relaxUniqueness(KEY key) {
            ((NativeIndexKey)((Object)key)).setCompareId(true);
        }
    }

    private static class CloseCancellation
    implements BlockStorage.Cancellation {
        private volatile boolean cancelled;

        private CloseCancellation() {
        }

        void setCancel() {
            this.cancelled = true;
        }

        @Override
        public boolean cancelled() {
            return this.cancelled;
        }
    }

    private class ThreadLocalBlockStorage
    extends BlockStorage.Monitor.Delegate {
        private final BlockStorage<KEY, VALUE> blockStorage;
        private volatile long count;
        private volatile boolean mergeStarted;
        private volatile long totalEntriesToMerge;
        private final AtomicLong entriesMerged;

        ThreadLocalBlockStorage(int id) throws IOException {
            super(BlockBasedIndexPopulator.this.blockStorageMonitor);
            this.entriesMerged = new AtomicLong();
            Path storeFile = BlockBasedIndexPopulator.this.indexFiles.getStoreFile();
            Path blockFile = storeFile.resolveSibling(storeFile.getFileName() + ".scan-" + id);
            this.blockStorage = new BlockStorage(BlockBasedIndexPopulator.this.layout, BlockBasedIndexPopulator.this.bufferFactory, BlockBasedIndexPopulator.this.fileSystem, blockFile, this, BlockBasedIndexPopulator.this.memoryTracker);
        }

        @Override
        public void mergeStarted(long entryCount, long totalEntriesToWriteDuringMerge) {
            super.mergeStarted(entryCount, totalEntriesToWriteDuringMerge);
            this.count = entryCount;
            this.totalEntriesToMerge = totalEntriesToWriteDuringMerge;
            this.mergeStarted = true;
        }

        @Override
        public void entriesMerged(int entries) {
            super.entriesMerged(entries);
            this.entriesMerged.addAndGet(entries);
        }
    }
}

