/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.KernelTransactionStamp;
import org.neo4j.kernel.impl.api.TransactionExecutionStatistic;
import org.neo4j.kernel.impl.api.transaction.trace.TransactionInitializationTrace;
import org.neo4j.lock.ActiveLock;
import org.neo4j.time.SystemNanoClock;

class KernelTransactionImplementationHandle
implements KernelTransactionHandle {
    private static final String USER_TRANSACTION_NAME_SEPARATOR = "-transaction-";
    private final long lastTransactionTimestampWhenStarted;
    private final long startTime;
    private final long startTimeNanos;
    private final long timeoutMillis;
    private final KernelTransactionImplementation tx;
    private final SystemNanoClock clock;
    private final ClientConnectionInfo clientInfo;
    private final AuthSubject subject;
    private final Optional<Status> terminationReason;
    private final Optional<ExecutingQuery> executingQuery;
    private final Map<String, Object> metaData;
    private final long userTransactionId;
    private final TransactionInitializationTrace initializationTrace;
    private final KernelTransactionStamp transactionStamp;
    private final String databaseName;

    KernelTransactionImplementationHandle(KernelTransactionImplementation tx, SystemNanoClock clock) {
        this.transactionStamp = new KernelTransactionStamp(tx);
        this.lastTransactionTimestampWhenStarted = tx.lastTransactionTimestampWhenStarted();
        this.startTime = tx.startTime();
        this.startTimeNanos = tx.startTimeNanos();
        this.timeoutMillis = tx.timeout();
        this.subject = tx.subjectOrAnonymous();
        this.terminationReason = tx.getReasonIfTerminated();
        this.executingQuery = tx.executingQuery();
        this.metaData = tx.getMetaData();
        this.userTransactionId = tx.getUserTransactionId();
        this.initializationTrace = tx.getInitializationTrace();
        this.clientInfo = tx.clientInfo();
        this.databaseName = tx.getDatabaseName();
        this.tx = tx;
        this.clock = clock;
    }

    @Override
    public long lastTransactionTimestampWhenStarted() {
        return this.lastTransactionTimestampWhenStarted;
    }

    @Override
    public long startTime() {
        return this.startTime;
    }

    @Override
    public long startTimeNanos() {
        return this.startTimeNanos;
    }

    @Override
    public long timeoutMillis() {
        return this.timeoutMillis;
    }

    @Override
    public boolean isOpen() {
        return this.transactionStamp.isOpen();
    }

    @Override
    public boolean isClosing() {
        return this.transactionStamp.isClosing();
    }

    @Override
    public boolean markForTermination(Status reason) {
        return this.tx.markForTermination(this.transactionStamp.getReuseCount(), reason);
    }

    @Override
    public AuthSubject subject() {
        return this.subject;
    }

    @Override
    public Map<String, Object> getMetaData() {
        return this.metaData;
    }

    @Override
    public Optional<Status> terminationReason() {
        return this.terminationReason;
    }

    @Override
    public boolean isUnderlyingTransaction(KernelTransaction tx) {
        return this.tx == tx;
    }

    @Override
    public long getUserTransactionId() {
        return this.userTransactionId;
    }

    @Override
    public String getUserTransactionName() {
        return this.databaseName + USER_TRANSACTION_NAME_SEPARATOR + this.getUserTransactionId();
    }

    @Override
    public Optional<ExecutingQuery> executingQuery() {
        return this.executingQuery;
    }

    @Override
    public Stream<ActiveLock> activeLocks() {
        return this.tx.activeLocks();
    }

    @Override
    public TransactionExecutionStatistic transactionStatistic() {
        if (this.transactionStamp.isNotExpired()) {
            return new TransactionExecutionStatistic(this.tx, this.clock, this.startTime);
        }
        return TransactionExecutionStatistic.NOT_AVAILABLE;
    }

    @Override
    public TransactionInitializationTrace transactionInitialisationTrace() {
        return this.initializationTrace;
    }

    @Override
    public Optional<ClientConnectionInfo> clientInfo() {
        return Optional.ofNullable(this.clientInfo);
    }

    @Override
    public boolean isSchemaTransaction() {
        return this.tx.isSchemaTransaction();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KernelTransactionImplementationHandle that = (KernelTransactionImplementationHandle)o;
        return this.transactionStamp.equals(that.transactionStamp);
    }

    public int hashCode() {
        return this.transactionStamp.hashCode();
    }

    public String toString() {
        return "KernelTransactionImplementationHandle{txReuseCount=" + this.transactionStamp.getReuseCount() + ", tx=" + this.tx + "}";
    }
}

