/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.IndexProxyStrategy;
import org.neo4j.storageengine.api.IndexEntryUpdate;

public class UpdateCountingIndexUpdater
implements IndexUpdater {
    private final IndexProxyStrategy indexProxyStrategy;
    private final IndexUpdater delegate;
    private long updates;

    public UpdateCountingIndexUpdater(IndexProxyStrategy indexProxyStrategy, IndexUpdater delegate) {
        this.indexProxyStrategy = indexProxyStrategy;
        this.delegate = delegate;
    }

    public void process(IndexEntryUpdate<?> update) throws IndexEntryConflictException {
        this.delegate.process(update);
        ++this.updates;
    }

    public void close() throws IndexEntryConflictException {
        this.delegate.close();
        this.indexProxyStrategy.incrementUpdateStatisticsForIndex(this.updates);
    }
}

