/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Objects;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.WritableChecksumChannel;
import org.neo4j.io.memory.NativeScopedBuffer;
import org.neo4j.io.memory.ScopedBuffer;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PositionAwarePhysicalFlushableChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckpointAppender;
import org.neo4j.kernel.impl.transaction.log.entry.DetachedCheckpointLogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogChannelAllocator;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesContext;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.log.rotation.monitor.LogRotationMonitor;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogForceEvent;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.monitoring.Health;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.StoreId;

public class DetachedCheckpointAppender
extends LifecycleAdapter
implements CheckpointAppender {
    private static final String CHECKPOINT_LOG_FILE_ROTATION_TAG = "checkpointLogFileRotation";
    private final CheckpointFile checkpointFile;
    private final TransactionLogChannelAllocator channelAllocator;
    private final TransactionLogFilesContext context;
    private final Health databaseHealth;
    private final LogRotation logRotation;
    private final PageCacheTracer pageCacheTracer;
    private StoreId storeId;
    private PositionAwarePhysicalFlushableChecksumChannel writer;
    private DetachedCheckpointLogEntryWriter checkpointWriter;
    private NativeScopedBuffer buffer;
    private PhysicalLogVersionedStoreChannel channel;
    private LogVersionRepository logVersionRepository;
    private final Log log;

    public DetachedCheckpointAppender(TransactionLogChannelAllocator channelAllocator, TransactionLogFilesContext context, CheckpointFile checkpointFile, LogRotation checkpointRotation) {
        this.checkpointFile = Objects.requireNonNull(checkpointFile);
        this.context = Objects.requireNonNull(context);
        this.pageCacheTracer = Objects.requireNonNull(context.getDatabaseTracers().getPageCacheTracer());
        this.channelAllocator = Objects.requireNonNull(channelAllocator);
        this.databaseHealth = (Health)Objects.requireNonNull(context.getDatabaseHealth());
        this.logRotation = Objects.requireNonNull(checkpointRotation);
        this.log = context.getLogProvider().getLog(DetachedCheckpointAppender.class);
    }

    public void start() throws IOException {
        this.storeId = this.context.getStoreId();
        this.logVersionRepository = Objects.requireNonNull(this.context.getLogVersionRepository());
        long initialVersion = this.logVersionRepository.getCheckpointLogVersion();
        this.channel = this.channelAllocator.createLogChannel(initialVersion, this.context::getLastCommittedTransactionId);
        ((LogRotationMonitor)this.context.getMonitors().newMonitor(LogRotationMonitor.class, new String[0])).started(this.channel.getPath(), initialVersion);
        this.channel.position(this.channel.size());
        this.buffer = new NativeScopedBuffer(ByteUnit.kibiBytes((long)1L), this.context.getMemoryTracker());
        this.writer = new PositionAwarePhysicalFlushableChecksumChannel(this.channel, (ScopedBuffer)this.buffer);
        this.checkpointWriter = new DetachedCheckpointLogEntryWriter((WritableChecksumChannel)this.writer);
    }

    public void shutdown() throws Exception {
        IOUtils.closeAll((AutoCloseable[])new AutoCloseable[]{this.writer, this.buffer, this.channel});
        this.writer = null;
        this.buffer = null;
        this.channel = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkPoint(LogCheckPointEvent logCheckPointEvent, LogPosition logPosition, Instant checkpointTime, String reason) throws IOException {
        if (this.checkpointWriter == null) {
            this.log.warn("Checkpoint was attempted while appender is not started. No checkpoint record will be appended.");
            return;
        }
        CheckpointFile checkpointFile = this.checkpointFile;
        synchronized (checkpointFile) {
            try {
                this.databaseHealth.assertHealthy(IOException.class);
                LogPosition logPositionBeforeCheckpoint = this.writer.getCurrentPosition();
                this.checkpointWriter.writeCheckPointEntry(logPosition, checkpointTime, this.storeId, reason);
                LogPosition logPositionAfterCheckpoint = this.writer.getCurrentPosition();
                logCheckPointEvent.appendToLogFile(logPositionBeforeCheckpoint, logPositionAfterCheckpoint);
                this.forceAfterAppend(logCheckPointEvent);
            }
            catch (Throwable cause) {
                this.databaseHealth.panic(cause);
                throw cause;
            }
        }
        this.logRotation.rotateLogIfNeeded(logCheckPointEvent);
    }

    public long getCurrentPosition() {
        return this.channel.position();
    }

    private void forceAfterAppend(LogCheckPointEvent logCheckPointEvent) throws IOException {
        try (LogForceEvent logForceEvent = logCheckPointEvent.beginLogForce();){
            this.writer.prepareForFlush().flush();
        }
    }

    public Path rotate() throws IOException {
        try (CursorContext cursorContext = new CursorContext(this.pageCacheTracer.createPageCursorTracer(CHECKPOINT_LOG_FILE_ROTATION_TAG));){
            this.channel = this.rotateChannel(this.channel, cursorContext);
            this.writer.setChannel(this.channel);
            Path path = this.channel.getPath();
            return path;
        }
    }

    private PhysicalLogVersionedStoreChannel rotateChannel(PhysicalLogVersionedStoreChannel channel, CursorContext cursorContext) throws IOException {
        long newLogVersion = this.logVersionRepository.incrementAndGetCheckpointLogVersion(cursorContext);
        this.writer.prepareForFlush().flush();
        PhysicalLogVersionedStoreChannel newChannel = this.channelAllocator.createLogChannel(newLogVersion, this.context::committingTransactionId);
        channel.close();
        return newChannel;
    }
}

