/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.neo4j.graphdb.Resource;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.kernel.api.index.EntityRange;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.impl.index.schema.TokenScanKey;
import org.neo4j.kernel.impl.index.schema.TokenScanValue;
import org.neo4j.kernel.impl.index.schema.TokenScanValueIndexAccessor;

public class TokenScanValueIndexProgressor
extends TokenScanValueIndexAccessor
implements IndexProgressor,
Resource {
    private final IndexProgressor.EntityTokenClient client;
    private final IndexOrder indexOrder;
    private final EntityRange range;

    TokenScanValueIndexProgressor(Seeker<TokenScanKey, TokenScanValue> cursor, IndexProgressor.EntityTokenClient client, IndexOrder indexOrder, EntityRange range) {
        super(cursor);
        this.client = client;
        this.indexOrder = indexOrder;
        this.range = range;
    }

    public boolean next() {
        while (true) {
            if (this.bits != 0L) {
                long idForClient;
                int delta;
                if (this.indexOrder != IndexOrder.DESCENDING) {
                    delta = Long.numberOfTrailingZeros(this.bits);
                    this.bits &= this.bits - 1L;
                    idForClient = this.baseEntityId + (long)delta;
                } else {
                    delta = Long.numberOfLeadingZeros(this.bits);
                    long bitToZeroe = 1L << 64 - delta - 1;
                    this.bits &= bitToZeroe ^ 0xFFFFFFFFFFFFFFFFL;
                    idForClient = this.baseEntityId + 64L - 1L - (long)delta;
                }
                if (!this.isInRange(idForClient) || !this.client.acceptEntity(idForClient, null)) continue;
                return true;
            }
            try {
                if (!this.cursor.next()) {
                    return false;
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            TokenScanKey key = (TokenScanKey)this.cursor.key();
            this.baseEntityId = key.idRange * 64L;
            this.bits = ((TokenScanValue)this.cursor.value()).bits;
            if (!$assertionsDisabled && !this.keysInOrder(key, this.indexOrder)) break;
        }
        throw new AssertionError();
    }

    private boolean isInRange(long entityId) {
        return entityId >= this.range.fromInclusive && entityId < this.range.toExclusive;
    }
}

