/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.impl.iterator.ImmutableEmptyLongIterator;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.kernel.impl.newapi.CursorPool;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipCursor;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.storageengine.api.ReadTracer;
import org.neo4j.storageengine.api.RelationshipSelection;
import org.neo4j.storageengine.api.StorageRelationshipTraversalCursor;
import org.neo4j.storageengine.api.txstate.NodeState;

class DefaultRelationshipTraversalCursor
extends DefaultRelationshipCursor<StorageRelationshipTraversalCursor, DefaultRelationshipTraversalCursor>
implements RelationshipTraversalCursor {
    private final DefaultNodeCursor nodeCursor;
    private LongIterator addedRelationships;
    private long originNodeReference;
    private RelationshipSelection selection;
    private AccessMode mode;

    DefaultRelationshipTraversalCursor(CursorPool<DefaultRelationshipTraversalCursor> pool, StorageRelationshipTraversalCursor storeCursor, DefaultNodeCursor nodeCursor) {
        super(storeCursor, pool);
        this.nodeCursor = nodeCursor;
    }

    void init(long nodeReference, long reference, RelationshipSelection selection, Read read) {
        this.originNodeReference = nodeReference;
        this.selection = selection;
        ((StorageRelationshipTraversalCursor)this.storeCursor).init(nodeReference, reference, selection);
        this.init(read);
        this.addedRelationships = ImmutableEmptyLongIterator.INSTANCE;
    }

    void init(DefaultNodeCursor nodeCursor, RelationshipSelection selection, Read read) {
        this.originNodeReference = nodeCursor.nodeReference();
        this.selection = selection;
        nodeCursor.storeCursor.relationships((StorageRelationshipTraversalCursor)this.storeCursor, selection);
        this.init(read);
        this.addedRelationships = ImmutableEmptyLongIterator.INSTANCE;
    }

    public void otherNode(NodeCursor cursor) {
        this.read.singleNode(this.otherNodeReference(), cursor);
    }

    public long otherNodeReference() {
        if (this.currentAddedInTx != -1L) {
            long originNodeReference = this.originNodeReference();
            if (this.txStateSourceNodeReference == originNodeReference) {
                return this.txStateTargetNodeReference;
            }
            if (this.txStateTargetNodeReference == originNodeReference) {
                return this.txStateSourceNodeReference;
            }
            throw new IllegalStateException(String.format("Relationship[%d] which was added in tx has an origin node [%d] which is neither source [%d] nor target [%d]", this.currentAddedInTx, originNodeReference, this.txStateSourceNodeReference, this.txStateTargetNodeReference));
        }
        return ((StorageRelationshipTraversalCursor)this.storeCursor).neighbourNodeReference();
    }

    public long originNodeReference() {
        return this.originNodeReference;
    }

    public boolean next() {
        boolean hasChanges = this.hasChanges();
        if (hasChanges) {
            if (this.addedRelationships.hasNext()) {
                this.read.txState().relationshipVisit(this.addedRelationships.next(), this.relationshipTxStateDataVisitor);
                if (this.tracer != null) {
                    this.tracer.onRelationship(this.relationshipReference());
                }
                return true;
            }
            this.currentAddedInTx = -1L;
        }
        while (((StorageRelationshipTraversalCursor)this.storeCursor).next()) {
            boolean skip = hasChanges && this.read.txState().relationshipIsDeletedInThisTx(((StorageRelationshipTraversalCursor)this.storeCursor).entityReference());
            if (skip || !this.allowed()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setTracer(KernelReadTracer tracer) {
        super.setTracer(tracer);
        ((StorageRelationshipTraversalCursor)this.storeCursor).setTracer((ReadTracer)tracer);
    }

    @Override
    public void removeTracer() {
        ((StorageRelationshipTraversalCursor)this.storeCursor).removeTracer();
        super.removeTracer();
    }

    boolean allowed() {
        if (this.mode == null) {
            this.mode = this.read.ktx.securityContext().mode();
        }
        return this.mode.allowsTraverseRelType(((StorageRelationshipTraversalCursor)this.storeCursor).type()) && this.allowedToSeeEndNode(this.mode);
    }

    private boolean allowedToSeeEndNode(AccessMode mode) {
        if (mode.allowsTraverseAllLabels()) {
            return true;
        }
        this.read.singleNode(((StorageRelationshipTraversalCursor)this.storeCursor).neighbourNodeReference(), this.nodeCursor);
        return this.nodeCursor.next();
    }

    @Override
    public void closeInternal() {
        if (!this.isClosed()) {
            this.read = null;
            this.selection = null;
            this.mode = null;
            ((StorageRelationshipTraversalCursor)this.storeCursor).close();
        }
        super.closeInternal();
    }

    @Override
    protected void collectAddedTxStateSnapshot() {
        NodeState nodeState = this.read.txState().getNodeState(this.originNodeReference);
        this.addedRelationships = this.selection.addedRelationship(nodeState);
    }

    public boolean isClosed() {
        return this.read == null;
    }

    public void release() {
        if (this.storeCursor != null) {
            ((StorageRelationshipTraversalCursor)this.storeCursor).close();
        }
        if (this.nodeCursor != null) {
            this.nodeCursor.close();
            this.nodeCursor.release();
        }
    }

    public String toString() {
        if (this.isClosed()) {
            return "RelationshipTraversalCursor[closed state]";
        }
        return "RelationshipTraversalCursor[id=" + ((StorageRelationshipTraversalCursor)this.storeCursor).entityReference() + ", " + this.storeCursor + "]";
    }
}

