/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.collection.Dependencies;
import org.neo4j.collection.pool.Pool;
import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.collection.trackable.HeapTrackingCollections;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.helpers.DatabaseReadOnlyChecker;
import org.neo4j.dbms.database.DbmsRuntimeRepository;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.graphdb.TransientFailureException;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.ExecutionStatistics;
import org.neo4j.internal.kernel.api.Locks;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Procedures;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.Token;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.exceptions.ConstraintViolationTransactionFailureException;
import org.neo4j.internal.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.internal.kernel.api.exceptions.LocksNotFrozenException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.kernel.api.security.SecurityAuthorizationHandler;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.VersionContextSupplier;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.api.ClockContext;
import org.neo4j.kernel.impl.api.InjectedNLIUpgradeCallback;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.LeaseClient;
import org.neo4j.kernel.impl.api.LeaseService;
import org.neo4j.kernel.impl.api.RestrictedSchemaWrite;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.api.transaction.trace.TraceProvider;
import org.neo4j.kernel.impl.api.transaction.trace.TraceProviderFactory;
import org.neo4j.kernel.impl.api.transaction.trace.TransactionInitializationTrace;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.factory.AccessCapability;
import org.neo4j.kernel.impl.factory.AccessCapabilityFactory;
import org.neo4j.kernel.impl.locking.FrozenLockClient;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.newapi.AllStoreHolder;
import org.neo4j.kernel.impl.newapi.DefaultPooledCursors;
import org.neo4j.kernel.impl.newapi.IndexTxStateUpdater;
import org.neo4j.kernel.impl.newapi.KernelToken;
import org.neo4j.kernel.impl.newapi.Operations;
import org.neo4j.kernel.impl.query.TransactionExecutionMonitor;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionTracer;
import org.neo4j.kernel.impl.util.collection.CollectionsFactory;
import org.neo4j.kernel.impl.util.collection.CollectionsFactorySupplier;
import org.neo4j.kernel.internal.event.DatabaseTransactionEventListeners;
import org.neo4j.kernel.internal.event.TransactionListenersState;
import org.neo4j.lock.ActiveLock;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceLocker;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.LimitedMemoryTracker;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryPool;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.memory.ScopedMemoryPool;
import org.neo4j.resources.CpuClock;
import org.neo4j.resources.HeapAllocation;
import org.neo4j.storageengine.api.CommandCreationContext;
import org.neo4j.storageengine.api.KernelVersionRepository;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.token.TokenHolders;

public class KernelTransactionImplementation
implements KernelTransaction,
TxStateHolder,
ExecutionStatistics {
    private static final long NOT_COMMITTED_TRANSACTION_ID = -1L;
    private static final long NOT_COMMITTED_TRANSACTION_COMMIT_TIME = -1L;
    private static final String TRANSACTION_TAG = "transaction";
    private final CollectionsFactory collectionsFactory;
    private final DatabaseTransactionEventListeners eventListeners;
    private final ConstraintIndexCreator constraintIndexCreator;
    private final StorageEngine storageEngine;
    private final TransactionTracer transactionTracer;
    private final PageCacheTracer pageCacheTracer;
    private final Pool<KernelTransactionImplementation> pool;
    private final TransactionCommitProcess commitProcess;
    private final TransactionMonitor transactionMonitor;
    private final TransactionExecutionMonitor transactionExecutionMonitor;
    private final VersionContextSupplier versionContextSupplier;
    private final LeaseService leaseService;
    private final StorageReader storageReader;
    private final CommandCreationContext commandCreationContext;
    private final NamedDatabaseId namedDatabaseId;
    private final ClockContext clocks;
    private final AccessCapabilityFactory accessCapabilityFactory;
    private final ConstraintSemantics constraintSemantics;
    private CursorContext cursorContext;
    private final DatabaseReadOnlyChecker readOnlyDatabaseChecker;
    private final SecurityAuthorizationHandler securityAuthorizationHandler;
    private TxState txState;
    private volatile TransactionWriteState writeState;
    private AccessCapability accessCapability;
    private final KernelStatement currentStatement;
    private SecurityContext securityContext;
    private volatile Locks.Client lockClient;
    private volatile long userTransactionId;
    private LeaseClient leaseClient;
    private volatile boolean closing;
    private volatile boolean closed;
    private boolean failure;
    private boolean success;
    private volatile Status terminationReason;
    private long startTimeMillis;
    private volatile long startTimeNanos;
    private volatile long timeoutMillis;
    private long lastTransactionIdWhenStarted;
    private volatile long lastTransactionTimestampWhenStarted;
    private final Statistics statistics;
    private TransactionEvent transactionEvent;
    private KernelTransaction.Type type;
    private long transactionId;
    private long commitTime;
    private volatile ClientConnectionInfo clientInfo;
    private volatile int reuseCount;
    private volatile Map<String, Object> userMetaData;
    private final AllStoreHolder allStoreHolder;
    private final Operations operations;
    private InternalTransaction internalTransaction;
    private volatile TraceProvider traceProvider;
    private volatile TransactionInitializationTrace initializationTrace;
    private final LimitedMemoryTracker memoryTracker;
    private final Config config;
    private volatile long transactionHeapBytesLimit;
    private final Lock terminationReleaseLock = new ReentrantLock();
    private KernelTransaction.KernelTransactionMonitor kernelTransactionMonitor;

    public KernelTransactionImplementation(Config config, DatabaseTransactionEventListeners eventListeners, ConstraintIndexCreator constraintIndexCreator, GlobalProcedures globalProcedures, TransactionCommitProcess commitProcess, TransactionMonitor transactionMonitor, Pool<KernelTransactionImplementation> pool, SystemNanoClock clock, AtomicReference<CpuClock> cpuClockRef, DatabaseTracers tracers, StorageEngine storageEngine, AccessCapabilityFactory accessCapabilityFactory, VersionContextSupplier versionContextSupplier, CollectionsFactorySupplier collectionsFactorySupplier, ConstraintSemantics constraintSemantics, SchemaState schemaState, TokenHolders tokenHolders, IndexingService indexingService, IndexStatisticsStore indexStatisticsStore, Dependencies dependencies, NamedDatabaseId namedDatabaseId, LeaseService leaseService, ScopedMemoryPool transactionMemoryPool, DatabaseReadOnlyChecker readOnlyDatabaseChecker, TransactionExecutionMonitor transactionExecutionMonitor, AbstractSecurityLog securityLog, KernelVersionRepository kernelVersionRepository, DbmsRuntimeRepository dbmsRuntimeRepository, LogProvider internalLogProvider) {
        this.accessCapabilityFactory = accessCapabilityFactory;
        this.readOnlyDatabaseChecker = readOnlyDatabaseChecker;
        long heapGrabSize = (Long)config.get(GraphDatabaseInternalSettings.initial_transaction_heap_grab_size);
        this.memoryTracker = (Boolean)config.get(GraphDatabaseSettings.memory_tracking) != false ? new LocalMemoryTracker((MemoryPool)transactionMemoryPool, 0L, heapGrabSize, GraphDatabaseSettings.memory_transaction_max_size.name(), KernelTransactionImplementation.memoryLeakLogger(internalLogProvider.getLog(this.getClass()))) : EmptyMemoryTracker.INSTANCE;
        this.eventListeners = eventListeners;
        this.constraintIndexCreator = constraintIndexCreator;
        this.commitProcess = commitProcess;
        this.transactionMonitor = transactionMonitor;
        this.transactionExecutionMonitor = transactionExecutionMonitor;
        this.storageReader = storageEngine.newReader();
        this.commandCreationContext = storageEngine.newCommandCreationContext((MemoryTracker)this.memoryTracker);
        this.namedDatabaseId = namedDatabaseId;
        this.storageEngine = storageEngine;
        this.pool = pool;
        this.clocks = new ClockContext(clock);
        this.transactionTracer = tracers.getDatabaseTracer();
        this.pageCacheTracer = tracers.getPageCacheTracer();
        this.versionContextSupplier = versionContextSupplier;
        this.leaseService = leaseService;
        this.currentStatement = new KernelStatement(this, tracers.getLockTracer(), this.clocks, cpuClockRef, namedDatabaseId, config);
        this.statistics = new Statistics(this, cpuClockRef, (Boolean)config.get(GraphDatabaseInternalSettings.enable_transaction_heap_allocation_tracking));
        this.userMetaData = Collections.emptyMap();
        this.constraintSemantics = constraintSemantics;
        DefaultPooledCursors cursors = new DefaultPooledCursors(this.storageReader, config);
        this.securityAuthorizationHandler = new SecurityAuthorizationHandler(securityLog);
        this.allStoreHolder = new AllStoreHolder(this.storageReader, this, cursors, globalProcedures, schemaState, indexingService, indexStatisticsStore, dependencies, config, (MemoryTracker)this.memoryTracker);
        this.operations = new Operations(this.allStoreHolder, this.storageReader, new IndexTxStateUpdater(this.storageReader, this.allStoreHolder, indexingService), this.commandCreationContext, this, new KernelToken(this.storageReader, this.commandCreationContext, this, tokenHolders), cursors, constraintIndexCreator, constraintSemantics, indexingService, config, (MemoryTracker)this.memoryTracker, kernelVersionRepository, dbmsRuntimeRepository);
        this.traceProvider = TraceProviderFactory.getTraceProvider(config);
        this.transactionHeapBytesLimit = (Long)config.get(GraphDatabaseSettings.memory_transaction_max_size);
        this.registerConfigChangeListeners(config);
        this.config = config;
        this.collectionsFactory = collectionsFactorySupplier.create();
    }

    public KernelTransactionImplementation initialize(long lastCommittedTx, long lastTimeStamp, Locks.Client lockClient, KernelTransaction.Type type, SecurityContext frozenSecurityContext, long transactionTimeout, long userTransactionId, ClientConnectionInfo clientInfo) {
        this.cursorContext = new CursorContext(this.pageCacheTracer.createPageCursorTracer(TRANSACTION_TAG), this.versionContextSupplier.createVersionContext());
        this.accessCapability = this.accessCapabilityFactory.newAccessCapability(this.readOnlyDatabaseChecker);
        this.kernelTransactionMonitor = KernelTransaction.NO_MONITOR;
        this.type = type;
        this.lockClient = lockClient;
        this.userTransactionId = userTransactionId;
        this.leaseClient = this.leaseService.newClient();
        this.lockClient.initialize(this.leaseClient, userTransactionId, (MemoryTracker)this.memoryTracker, this.config);
        this.terminationReason = null;
        this.closing = false;
        this.closed = false;
        this.failure = false;
        this.success = false;
        this.writeState = TransactionWriteState.NONE;
        this.startTimeMillis = this.clocks.systemClock().millis();
        this.startTimeNanos = this.clocks.systemClock().nanos();
        this.timeoutMillis = transactionTimeout;
        this.lastTransactionIdWhenStarted = lastCommittedTx;
        this.lastTransactionTimestampWhenStarted = lastTimeStamp;
        this.transactionEvent = this.transactionTracer.beginTransaction(this.cursorContext);
        this.securityContext = frozenSecurityContext;
        this.transactionId = -1L;
        this.commitTime = -1L;
        this.clientInfo = clientInfo;
        this.statistics.init(Thread.currentThread().getId(), this.cursorContext);
        this.commandCreationContext.initialize(this.cursorContext);
        this.currentStatement.initialize(lockClient, this.cursorContext, this.startTimeMillis);
        this.operations.initialize(this.cursorContext);
        this.initializationTrace = this.traceProvider.getTraceInfo();
        this.memoryTracker.setLimit(this.transactionHeapBytesLimit);
        return this;
    }

    public void bindToUserTransaction(InternalTransaction internalTransaction) {
        this.internalTransaction = internalTransaction;
    }

    public InternalTransaction internalTransaction() {
        return this.internalTransaction;
    }

    int getReuseCount() {
        return this.reuseCount;
    }

    public long startTime() {
        return this.startTimeMillis;
    }

    public long startTimeNanos() {
        return this.startTimeNanos;
    }

    public long timeout() {
        return this.timeoutMillis;
    }

    public long lastTransactionIdWhenStarted() {
        return this.lastTransactionIdWhenStarted;
    }

    public void success() {
        this.success = true;
    }

    boolean isSuccess() {
        return this.success;
    }

    public void failure() {
        this.failure = true;
    }

    public Optional<Status> getReasonIfTerminated() {
        return Optional.ofNullable(this.terminationReason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean markForTermination(long expectedReuseCount, Status reason) {
        this.terminationReleaseLock.lock();
        try {
            boolean bl = expectedReuseCount == (long)this.reuseCount && this.markForTerminationIfPossible(reason);
            return bl;
        }
        finally {
            this.terminationReleaseLock.unlock();
        }
    }

    public void markForTermination(Status reason) {
        this.terminationReleaseLock.lock();
        try {
            this.markForTerminationIfPossible(reason);
        }
        finally {
            this.terminationReleaseLock.unlock();
        }
    }

    public boolean isSchemaTransaction() {
        return this.writeState == TransactionWriteState.SCHEMA;
    }

    public CursorContext cursorContext() {
        return this.cursorContext;
    }

    public MemoryTracker memoryTracker() {
        return this.memoryTracker;
    }

    private boolean markForTerminationIfPossible(Status reason) {
        if (this.canBeTerminated()) {
            this.failure = true;
            this.terminationReason = reason;
            if (this.lockClient != null) {
                this.lockClient.stop();
            }
            this.transactionMonitor.transactionTerminated(this.hasTxStateWithChanges());
            InternalTransaction internalTransaction = this.internalTransaction;
            if (internalTransaction != null) {
                internalTransaction.terminate(reason);
            }
            return true;
        }
        return false;
    }

    public boolean isOpen() {
        return !this.closed && !this.closing;
    }

    public SecurityAuthorizationHandler securityAuthorizationHandler() {
        return this.securityAuthorizationHandler;
    }

    public SecurityContext securityContext() {
        if (this.securityContext == null) {
            throw new NotInTransactionException();
        }
        return this.securityContext;
    }

    public AuthSubject subjectOrAnonymous() {
        SecurityContext context = this.securityContext;
        return context == null ? AuthSubject.ANONYMOUS : context.subject();
    }

    public void setMetaData(Map<String, Object> data) {
        this.assertOpen();
        this.userMetaData = data;
    }

    public Map<String, Object> getMetaData() {
        return this.userMetaData;
    }

    public KernelStatement acquireStatement() {
        this.assertOpen();
        this.currentStatement.acquire();
        return this.currentStatement;
    }

    public IndexDescriptor indexUniqueCreate(IndexPrototype prototype) {
        return this.operations.indexUniqueCreate(prototype);
    }

    public long pageHits() {
        return this.cursorContext.getCursorTracer().hits();
    }

    public long pageFaults() {
        return this.cursorContext.getCursorTracer().faults();
    }

    Optional<ExecutingQuery> executingQuery() {
        return this.currentStatement.executingQuery();
    }

    private void upgradeToDataWrites() throws InvalidTransactionTypeKernelException {
        this.writeState = this.writeState.upgradeToDataWrites();
    }

    private void upgradeToSchemaWrites() throws InvalidTransactionTypeKernelException {
        this.writeState = this.writeState.upgradeToSchemaWrites();
    }

    private void dropCreatedConstraintIndexes() throws TransactionFailureException {
        if (this.hasTxStateWithChanges()) {
            Iterator createdIndexIds = this.txState().constraintIndexesCreatedInTx();
            while (createdIndexIds.hasNext()) {
                IndexDescriptor createdIndex = (IndexDescriptor)createdIndexIds.next();
                this.constraintIndexCreator.dropUniquenessConstraintIndex(createdIndex);
            }
        }
    }

    @Override
    public TransactionState txState() {
        if (this.txState == null) {
            this.leaseClient.ensureValid();
            this.readOnlyDatabaseChecker.check();
            this.transactionMonitor.upgradeToWriteTransaction();
            this.txState = new TxState(this.collectionsFactory, (MemoryTracker)this.memoryTracker);
        }
        return this.txState;
    }

    @Override
    public boolean hasTxStateWithChanges() {
        return this.txState != null && this.txState.hasChanges();
    }

    private void markAsClosed() {
        this.assertTransactionOpen();
        this.closed = true;
        this.closeCurrentStatementIfAny();
    }

    private void closeCurrentStatementIfAny() {
        this.currentStatement.forceClose();
    }

    private void assertTransactionNotClosing() {
        if (this.closing) {
            throw new IllegalStateException("This transaction is already being closed.");
        }
    }

    private void assertTransactionOpen() {
        if (this.closed) {
            throw new NotInTransactionException("This transaction has already been closed.");
        }
    }

    public void assertOpen() {
        Status reason = this.terminationReason;
        if (reason != null) {
            throw new TransactionTerminatedException(reason);
        }
        this.assertTransactionOpen();
    }

    private boolean hasChanges() {
        return this.hasTxStateWithChanges();
    }

    public long commit(KernelTransaction.KernelTransactionMonitor kernelTransactionMonitor) throws TransactionFailureException {
        this.success();
        this.kernelTransactionMonitor = kernelTransactionMonitor;
        return this.closeTransaction();
    }

    public void rollback() throws TransactionFailureException {
        if (!this.isOpen() && this.failure) {
            return;
        }
        this.failure();
        this.closeTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long closeTransaction() throws TransactionFailureException {
        block15: {
            this.assertTransactionOpen();
            this.assertTransactionNotClosing();
            this.closing = true;
            if (!this.failure && this.success && !this.isTerminated()) break block15;
            this.rollback(null);
            this.failOnNonExplicitRollbackIfNeeded();
            long l = -1L;
            try {
                this.closed = true;
                this.closing = false;
                this.transactionEvent.setSuccess(this.success);
                this.transactionEvent.setFailure(this.failure);
                this.transactionEvent.setTransactionWriteState(this.writeState.name());
                this.transactionEvent.setReadOnly(this.txState == null || !this.txState.hasChanges());
                this.transactionEvent.close();
                return l;
            }
            finally {
                this.release();
            }
        }
        long l = this.commitTransaction();
        try {
            this.closed = true;
            this.closing = false;
            this.transactionEvent.setSuccess(this.success);
            this.transactionEvent.setFailure(this.failure);
            this.transactionEvent.setTransactionWriteState(this.writeState.name());
            this.transactionEvent.setReadOnly(this.txState == null || !this.txState.hasChanges());
            this.transactionEvent.close();
            return l;
        }
        finally {
            this.release();
        }
        catch (TransactionFailureException e) {
            try {
                throw e;
                catch (KernelException e2) {
                    throw new TransactionFailureException(e2.status(), (Throwable)e2, "Unexpected kernel exception", new Object[0]);
                }
            }
            catch (Throwable throwable) {
                try {
                    this.closed = true;
                    this.closing = false;
                    this.transactionEvent.setSuccess(this.success);
                    this.transactionEvent.setFailure(this.failure);
                    this.transactionEvent.setTransactionWriteState(this.writeState.name());
                    this.transactionEvent.setReadOnly(this.txState == null || !this.txState.hasChanges());
                    this.transactionEvent.close();
                    throw throwable;
                }
                finally {
                    this.release();
                }
            }
        }
    }

    public boolean isClosing() {
        return this.closing;
    }

    private void failOnNonExplicitRollbackIfNeeded() throws TransactionFailureException {
        if (this.success && this.isTerminated()) {
            throw new TransactionTerminatedException(this.terminationReason);
        }
        if (this.success) {
            throw new TransactionFailureException((Status)Status.Transaction.TransactionMarkedAsFailed, "Transaction rolled back even if marked as successful", new Object[0]);
        }
    }

    /*
     * Loose catch block
     */
    private long commitTransaction() throws KernelException {
        long l;
        CommitEvent commitEvent;
        TransactionListenersState listenersState;
        long txId;
        boolean success;
        block19: {
            block18: {
                success = false;
                txId = 0L;
                listenersState = null;
                commitEvent = this.transactionEvent.beginCommitEvent();
                listenersState = this.eventListeners.beforeCommit(this.txState, this, this.storageReader);
                if (listenersState != null && listenersState.isFailed()) {
                    Throwable cause = listenersState.failure();
                    if (cause instanceof TransientFailureException) {
                        throw (TransientFailureException)cause;
                    }
                    if (cause instanceof Status.HasStatus) {
                        throw new TransactionFailureException(((Status.HasStatus)cause).status(), cause, cause.getMessage(), new Object[0]);
                    }
                    throw new TransactionFailureException((Status)Status.Transaction.TransactionHookFailed, cause, cause.getMessage(), new Object[0]);
                }
                if (this.hasChanges()) {
                    this.forceThawLocks();
                    this.lockClient.prepareForCommit();
                    HeapTrackingArrayList extractedCommands = HeapTrackingCollections.newArrayList((MemoryTracker)this.memoryTracker);
                    this.storageEngine.createCommands((Collection)extractedCommands, (ReadableTransactionState)this.txState, this.storageReader, this.commandCreationContext, (ResourceLocker)this.lockClient, this.lockTracer(), this.lastTransactionIdWhenStarted, this::enforceConstraints, this.cursorContext, (MemoryTracker)this.memoryTracker);
                    if (!extractedCommands.isEmpty()) {
                        PhysicalTransactionRepresentation transactionRepresentation = new PhysicalTransactionRepresentation((List<StorageCommand>)extractedCommands);
                        long timeCommitted = this.clocks.systemClock().millis();
                        transactionRepresentation.setHeader(ArrayUtils.EMPTY_BYTE_ARRAY, this.startTimeMillis, this.lastTransactionIdWhenStarted, timeCommitted, this.leaseClient.leaseId(), this.securityContext.subject());
                        success = true;
                        TransactionToApply batch = new TransactionToApply(transactionRepresentation, this.cursorContext);
                        this.kernelTransactionMonitor.beforeApply();
                        txId = this.commitProcess.commit(batch, commitEvent, TransactionApplicationMode.INTERNAL);
                        this.commitTime = timeCommitted;
                    }
                }
                success = true;
                l = txId;
                if (commitEvent != null) {
                    commitEvent.close();
                }
                if (success) break block18;
                this.rollback(listenersState);
                break block19;
            }
            this.transactionId = txId;
            this.afterCommit(listenersState);
        }
        this.transactionMonitor.addHeapTransactionSize(this.memoryTracker.heapHighWaterMark());
        this.transactionMonitor.addNativeTransactionSize(this.memoryTracker.usedNativeMemory());
        return l;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (commitEvent != null) {
                            try {
                                commitEvent.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (ConstraintValidationException | CreateConstraintFailureException e) {
                        throw new ConstraintViolationTransactionFailureException(e.getUserMessage((TokenNameLookup)this.tokenRead()), (KernelException)e);
                    }
                }
                catch (Throwable throwable3) {
                    if (!success) {
                        this.rollback(listenersState);
                    } else {
                        this.transactionId = txId;
                        this.afterCommit(listenersState);
                    }
                    this.transactionMonitor.addHeapTransactionSize(this.memoryTracker.heapHighWaterMark());
                    this.transactionMonitor.addNativeTransactionSize(this.memoryTracker.usedNativeMemory());
                    throw throwable3;
                }
            }
        }
    }

    private void rollback(TransactionListenersState listenersState) throws KernelException {
        try {
            try {
                this.dropCreatedConstraintIndexes();
            }
            catch (IllegalStateException | SecurityException e) {
                throw new TransactionFailureException((Status)Status.Transaction.TransactionRollbackFailed, (Throwable)e, "Could not drop created constraint indexes", new Object[0]);
            }
        }
        finally {
            this.afterRollback(listenersState);
        }
    }

    public Read dataRead() {
        return this.operations.dataRead();
    }

    public Write dataWrite() throws InvalidTransactionTypeKernelException {
        this.accessCapability.assertCanWrite();
        this.upgradeToDataWrites();
        return this.operations;
    }

    public TokenWrite tokenWrite() {
        this.accessCapability.assertCanWrite();
        return this.operations.token();
    }

    public Token token() {
        this.accessCapability.assertCanWrite();
        return this.operations.token();
    }

    public TokenRead tokenRead() {
        return this.operations.token();
    }

    public SchemaRead schemaRead() {
        return this.operations.schemaRead();
    }

    public SchemaWrite schemaWrite() throws InvalidTransactionTypeKernelException {
        this.accessCapability.assertCanWrite();
        this.securityAuthorizationHandler.assertAllowsSchemaWrites(this.securityContext());
        this.upgradeToSchemaWrites();
        return new RestrictedSchemaWrite(this.operations, this.securityContext(), this.securityAuthorizationHandler);
    }

    public Locks locks() {
        return this.operations.locks();
    }

    public void freezeLocks() {
        Locks.Client locks = this.lockClient;
        if (!(locks instanceof FrozenLockClient)) {
            this.lockClient = new FrozenLockClient(locks);
        } else {
            ((FrozenLockClient)locks).freeze();
        }
    }

    public void thawLocks() throws LocksNotFrozenException {
        Locks.Client locks = this.lockClient;
        if (locks instanceof FrozenLockClient) {
            FrozenLockClient frozenLocks = (FrozenLockClient)locks;
            if (frozenLocks.thaw()) {
                this.lockClient = frozenLocks.getRealLockClient();
            }
        } else {
            throw new LocksNotFrozenException();
        }
    }

    private void forceThawLocks() {
        Locks.Client locks = this.lockClient;
        if (locks instanceof FrozenLockClient) {
            this.lockClient = ((FrozenLockClient)locks).getRealLockClient();
        }
    }

    public Locks.Client lockClient() {
        this.assertOpen();
        return this.lockClient;
    }

    public CursorFactory cursors() {
        return this.operations.cursors();
    }

    public Procedures procedures() {
        return this.operations.procedures();
    }

    public ExecutionStatistics executionStatistics() {
        return this;
    }

    public LockTracer lockTracer() {
        return this.currentStatement.lockTracer();
    }

    private void afterCommit(TransactionListenersState listenersState) {
        try {
            this.markAsClosed();
            this.eventListeners.afterCommit(listenersState);
        }
        finally {
            this.transactionMonitor.transactionFinished(true, this.hasTxStateWithChanges());
            this.transactionExecutionMonitor.commit(this);
        }
    }

    private void afterRollback(TransactionListenersState listenersState) {
        try {
            this.markAsClosed();
            this.eventListeners.afterRollback(listenersState);
        }
        finally {
            this.transactionMonitor.transactionFinished(false, this.hasTxStateWithChanges());
            if (listenersState == null || listenersState.failure() == null) {
                this.transactionExecutionMonitor.rollback(this);
            } else {
                this.transactionExecutionMonitor.rollback(this, listenersState.failure());
            }
        }
    }

    void releaseStatementResources() {
        this.allStoreHolder.release();
    }

    private void release() {
        this.terminationReleaseLock.lock();
        try {
            this.forceThawLocks();
            this.lockClient.close();
            this.lockClient = null;
            this.terminationReason = null;
            this.type = null;
            this.securityContext = null;
            this.transactionEvent = null;
            this.txState = null;
            this.collectionsFactory.release();
            ++this.reuseCount;
            this.userMetaData = Collections.emptyMap();
            this.clientInfo = null;
            this.internalTransaction = null;
            this.userTransactionId = 0L;
            this.statistics.reset();
            this.releaseStatementResources();
            this.operations.release();
            this.commandCreationContext.close();
            this.cursorContext.close();
            this.initializationTrace = TransactionInitializationTrace.NONE;
            this.pool.release((Object)this);
            this.memoryTracker.reset();
        }
        finally {
            this.terminationReleaseLock.unlock();
        }
    }

    private boolean canBeTerminated() {
        return !this.closed && !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.terminationReason != null;
    }

    public long lastTransactionTimestampWhenStarted() {
        return this.lastTransactionTimestampWhenStarted;
    }

    public KernelTransaction.Type transactionType() {
        return this.type;
    }

    public long getTransactionId() {
        if (this.transactionId == -1L) {
            throw new IllegalStateException("Transaction id is not assigned yet. It will be assigned during transaction commit.");
        }
        return this.transactionId;
    }

    public long getCommitTime() {
        if (this.commitTime == -1L) {
            throw new IllegalStateException("Transaction commit time is not assigned yet. It will be assigned during transaction commit.");
        }
        return this.commitTime;
    }

    public KernelTransaction.Revertable overrideWith(SecurityContext context) {
        SecurityContext oldContext = this.securityContext;
        this.securityContext = context;
        return () -> {
            this.securityContext = oldContext;
        };
    }

    public String toString() {
        return String.format("KernelTransaction[lease:%d]", this.leaseClient.leaseId());
    }

    public void dispose() {
        this.storageReader.close();
    }

    public Stream<ActiveLock> activeLocks() {
        Locks.Client locks = this.lockClient;
        return locks == null ? Stream.empty() : locks.activeLocks();
    }

    public long getUserTransactionId() {
        return this.userTransactionId;
    }

    TransactionInitializationTrace getInitializationTrace() {
        return this.initializationTrace;
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    private TxStateVisitor enforceConstraints(TxStateVisitor txStateVisitor) {
        return this.constraintSemantics.decorateTxStateVisitor(this.storageReader, this.operations.dataRead(), this.operations.cursors(), this.txState, txStateVisitor, this.cursorContext, (MemoryTracker)this.memoryTracker);
    }

    public ClientConnectionInfo clientInfo() {
        return this.clientInfo;
    }

    public StorageReader newStorageReader() {
        return this.storageEngine.newReader();
    }

    public void addIndexDoDropToTxState(IndexDescriptor index) {
        this.txState().indexDoDrop(index);
    }

    public String getDatabaseName() {
        return this.namedDatabaseId.name();
    }

    public UUID getDatabaseId() {
        return this.namedDatabaseId.databaseId().uuid();
    }

    public InjectedNLIUpgradeCallback injectedNLIUpgradeCallback() {
        return id -> {
            if (this.txState.indexChanges().getRemoved().contains(IndexDescriptor.INJECTED_NLI)) {
                this.txState.indexDoUnRemove(IndexDescriptor.INJECTED_NLI);
                this.txState.indexDoDrop(IndexDescriptor.NLI_PROTOTYPE.materialise(id));
            }
        };
    }

    public ClockContext clocks() {
        return this.clocks;
    }

    public NodeCursor ambientNodeCursor() {
        return this.operations.nodeCursor();
    }

    public RelationshipScanCursor ambientRelationshipCursor() {
        return this.operations.relationshipCursor();
    }

    public PropertyCursor ambientPropertyCursor() {
        return this.operations.propertyCursor();
    }

    private void registerConfigChangeListeners(Config config) {
        config.addListener(GraphDatabaseSettings.transaction_tracing_level, (before, after) -> {
            this.traceProvider = TraceProviderFactory.getTraceProvider(config);
        });
        config.addListener(GraphDatabaseSettings.transaction_sampling_percentage, (before, after) -> {
            this.traceProvider = TraceProviderFactory.getTraceProvider(config);
        });
        config.addListener(GraphDatabaseSettings.memory_transaction_max_size, (before, after) -> {
            this.transactionHeapBytesLimit = after;
        });
    }

    private static LocalMemoryTracker.Monitor memoryLeakLogger(Log log) {
        return leakedNativeMemoryBytes -> log.warn("Potential direct memory leak. Expecting all allocated direct memory to be released, but still has " + leakedNativeMemoryBytes);
    }

    private static enum TransactionWriteState {
        NONE,
        DATA{

            @Override
            TransactionWriteState upgradeToSchemaWrites() throws InvalidTransactionTypeKernelException {
                throw new InvalidTransactionTypeKernelException("Cannot perform schema updates in a transaction that has performed data updates.");
            }
        }
        ,
        SCHEMA{

            @Override
            TransactionWriteState upgradeToDataWrites() throws InvalidTransactionTypeKernelException {
                throw new InvalidTransactionTypeKernelException("Cannot perform data updates in a transaction that has performed schema updates.");
            }
        };


        TransactionWriteState upgradeToDataWrites() throws InvalidTransactionTypeKernelException {
            return DATA;
        }

        TransactionWriteState upgradeToSchemaWrites() throws InvalidTransactionTypeKernelException {
            return SCHEMA;
        }
    }

    public static class Statistics {
        private volatile long cpuTimeNanosWhenQueryStarted;
        private volatile long heapAllocatedBytesWhenQueryStarted;
        private volatile long waitingTimeNanos;
        private volatile long transactionThreadId;
        private volatile CursorContext cursorContext = CursorContext.NULL;
        private final KernelTransactionImplementation transaction;
        private final AtomicReference<CpuClock> cpuClockRef;
        private CpuClock cpuClock;
        private final HeapAllocation heapAllocation;

        public Statistics(KernelTransactionImplementation transaction, AtomicReference<CpuClock> cpuClockRef, boolean heapAllocationTracking) {
            this.transaction = transaction;
            this.cpuClockRef = cpuClockRef;
            this.heapAllocation = heapAllocationTracking ? HeapAllocation.HEAP_ALLOCATION : HeapAllocation.NOT_AVAILABLE;
        }

        protected void init(long threadId, CursorContext cursorContext) {
            this.cpuClock = this.cpuClockRef.get();
            this.transactionThreadId = threadId;
            this.cursorContext = cursorContext;
            this.cpuTimeNanosWhenQueryStarted = this.cpuClock.cpuTimeNanos(this.transactionThreadId);
            this.heapAllocatedBytesWhenQueryStarted = this.heapAllocation.allocatedBytes(this.transactionThreadId);
        }

        long heapAllocatedBytes() {
            return this.heapAllocation.allocatedBytes(this.transactionThreadId) - this.heapAllocatedBytesWhenQueryStarted;
        }

        long estimatedHeapMemory() {
            return this.transaction.memoryTracker().estimatedHeapMemory();
        }

        long usedNativeMemory() {
            return this.transaction.memoryTracker().usedNativeMemory();
        }

        public long cpuTimeMillis() {
            long cpuTimeNanos = this.cpuClock.cpuTimeNanos(this.transactionThreadId) - this.cpuTimeNanosWhenQueryStarted;
            return TimeUnit.NANOSECONDS.toMillis(cpuTimeNanos);
        }

        long totalTransactionPageCacheHits() {
            return this.cursorContext.getCursorTracer().hits();
        }

        long totalTransactionPageCacheFaults() {
            return this.cursorContext.getCursorTracer().faults();
        }

        void addWaitingTime(long waitTimeNanos) {
            this.waitingTimeNanos += waitTimeNanos;
        }

        long getWaitingTimeNanos(long nowNanos) {
            Optional<ExecutingQuery> query = this.transaction.executingQuery();
            long waitingTime = this.waitingTimeNanos;
            if (query.isPresent()) {
                long latestQueryWaitingNanos = query.get().totalWaitingTimeNanos(nowNanos);
                waitingTime += latestQueryWaitingNanos;
            }
            return waitingTime;
        }

        void reset() {
            this.cursorContext = CursorContext.NULL;
            this.cpuTimeNanosWhenQueryStarted = 0L;
            this.heapAllocatedBytesWhenQueryStarted = 0L;
            this.waitingTimeNanos = 0L;
            this.transactionThreadId = -1L;
        }
    }
}

