/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.nio.file.Path;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.common.EntityType;
import org.neo4j.configuration.Config;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.batchimport.IndexImporter;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.TokenIndexAccessor;
import org.neo4j.storageengine.api.IndexEntryUpdate;

public class TokenIndexImporter
implements IndexImporter {
    private final IndexUpdater updater;
    private final IndexDescriptor index;
    private final TokenIndexAccessor accessor;
    private final CursorContext cursorContext;

    TokenIndexImporter(IndexDescriptor index, DatabaseLayout layout, FileSystemAbstraction fs, PageCache cache, CursorContext cursorContext, Config config) {
        this.index = index;
        this.accessor = this.tokenIndexAccessor(layout, fs, cache, config);
        this.cursorContext = cursorContext;
        this.updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE, cursorContext);
    }

    public void add(long entity, long[] tokens) {
        try {
            this.updater.process((IndexEntryUpdate)IndexEntryUpdate.change((long)entity, (SchemaDescriptorSupplier)this.index, (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (long[])tokens));
        }
        catch (IndexEntryConflictException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() throws IOException {
        IOUtils.closeAll((AutoCloseable[])new AutoCloseable[]{this.updater, () -> this.accessor.force(this.cursorContext), this.accessor});
    }

    private TokenIndexAccessor tokenIndexAccessor(DatabaseLayout layout, FileSystemAbstraction fs, PageCache pageCache, Config config) {
        DatabaseIndexContext context = DatabaseIndexContext.builder(pageCache, fs, layout.getDatabaseName()).build();
        Path path = this.index.schema().entityType() == EntityType.NODE ? layout.labelScanStore() : layout.relationshipTypeScanStore();
        return new TokenIndexAccessor(context, layout, new IndexFiles.SingleFile(fs, path), config, this.index, RecoveryCleanupWorkCollector.immediate());
    }
}

