/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.factory;

import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.ResultTransformer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.availability.UnavailableException;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.coreapi.DefaultTransactionExceptionMapper;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.TransactionExceptionMapper;
import org.neo4j.kernel.impl.coreapi.TransactionImpl;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.impl.factory.FacadeKernelTransactionFactory;
import org.neo4j.kernel.impl.query.Neo4jTransactionalContextFactory;
import org.neo4j.kernel.impl.query.TransactionalContextFactory;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class GraphDatabaseFacade
implements GraphDatabaseAPI {
    private final Database database;
    protected final TransactionalContextFactory contextFactory;
    private final Config config;
    private final DatabaseAvailabilityGuard availabilityGuard;
    private final DbmsInfo dbmsInfo;
    private Function<LoginContext, LoginContext> loginContextTransformer = Function.identity();

    public GraphDatabaseFacade(GraphDatabaseFacade facade, Function<LoginContext, LoginContext> loginContextTransformer) {
        this(facade.database, facade.config, facade.dbmsInfo, facade.availabilityGuard);
        this.loginContextTransformer = Objects.requireNonNull(loginContextTransformer);
    }

    public GraphDatabaseFacade(Database database, Config config, DbmsInfo dbmsInfo, DatabaseAvailabilityGuard availabilityGuard) {
        this.database = Objects.requireNonNull(database);
        this.config = Objects.requireNonNull(config);
        this.availabilityGuard = Objects.requireNonNull(availabilityGuard);
        this.dbmsInfo = Objects.requireNonNull(dbmsInfo);
        this.contextFactory = Neo4jTransactionalContextFactory.create(() -> (GraphDatabaseQueryService)this.getDependencyResolver().resolveDependency(GraphDatabaseQueryService.class), new FacadeKernelTransactionFactory(config, this));
    }

    public boolean isAvailable(long timeoutMillis) {
        return this.database.getDatabaseAvailabilityGuard().isAvailable(timeoutMillis);
    }

    public Transaction beginTx() {
        return this.beginTransaction();
    }

    protected InternalTransaction beginTransaction() {
        return this.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);
    }

    public Transaction beginTx(long timeout, TimeUnit unit) {
        return this.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED, ClientConnectionInfo.EMBEDDED_CONNECTION, timeout, unit);
    }

    @Override
    public InternalTransaction beginTransaction(KernelTransaction.Type type, LoginContext loginContext) {
        return this.beginTransaction(type, loginContext, ClientConnectionInfo.EMBEDDED_CONNECTION);
    }

    @Override
    public InternalTransaction beginTransaction(KernelTransaction.Type type, LoginContext loginContext, ClientConnectionInfo clientInfo) {
        return this.beginTransactionInternal(type, loginContext, clientInfo, ((Duration)this.config.get(GraphDatabaseSettings.transaction_timeout)).toMillis(), null, DefaultTransactionExceptionMapper.INSTANCE);
    }

    @Override
    public InternalTransaction beginTransaction(KernelTransaction.Type type, LoginContext loginContext, ClientConnectionInfo clientInfo, long timeout, TimeUnit unit) {
        return this.beginTransactionInternal(type, loginContext, clientInfo, unit.toMillis(timeout), null, DefaultTransactionExceptionMapper.INSTANCE);
    }

    public InternalTransaction beginTransaction(KernelTransaction.Type type, LoginContext loginContext, ClientConnectionInfo clientInfo, Consumer<Status> terminationCallback, TransactionExceptionMapper transactionExceptionMapper) {
        return this.beginTransactionInternal(type, loginContext, clientInfo, ((Duration)this.config.get(GraphDatabaseSettings.transaction_timeout)).toMillis(), terminationCallback, transactionExceptionMapper);
    }

    public void executeTransactionally(String query) throws QueryExecutionException {
        this.executeTransactionally(query, Collections.emptyMap(), ResultTransformer.EMPTY_TRANSFORMER);
    }

    public void executeTransactionally(String query, Map<String, Object> parameters) throws QueryExecutionException {
        this.executeTransactionally(query, parameters, ResultTransformer.EMPTY_TRANSFORMER);
    }

    public <T> T executeTransactionally(String query, Map<String, Object> parameters, ResultTransformer<T> resultTransformer) throws QueryExecutionException {
        return this.executeTransactionally(query, parameters, resultTransformer, (Duration)this.config.get(GraphDatabaseSettings.transaction_timeout));
    }

    public <T> T executeTransactionally(String query, Map<String, Object> parameters, ResultTransformer<T> resultTransformer, Duration timeout) throws QueryExecutionException {
        Object transformedResult;
        try (InternalTransaction internalTransaction = this.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED, ClientConnectionInfo.EMBEDDED_CONNECTION, timeout.toMillis(), TimeUnit.MILLISECONDS);){
            try (Result result = internalTransaction.execute(query, parameters);){
                transformedResult = resultTransformer.apply((Object)result);
            }
            internalTransaction.commit();
        }
        return (T)transformedResult;
    }

    protected InternalTransaction beginTransactionInternal(KernelTransaction.Type type, LoginContext loginContext, ClientConnectionInfo connectionInfo, long timeoutMillis, Consumer<Status> terminationCallback, TransactionExceptionMapper transactionExceptionMapper) {
        KernelTransaction kernelTransaction = this.beginKernelTransaction(type, loginContext, connectionInfo, timeoutMillis);
        return new TransactionImpl(this.database.getTokenHolders(), this.contextFactory, this.availabilityGuard, this.database.getExecutionEngine(), kernelTransaction, terminationCallback, transactionExceptionMapper);
    }

    @Override
    public NamedDatabaseId databaseId() {
        return this.database.getNamedDatabaseId();
    }

    @Override
    public DbmsInfo dbmsInfo() {
        return this.dbmsInfo;
    }

    KernelTransaction beginKernelTransaction(KernelTransaction.Type type, LoginContext loginContext, ClientConnectionInfo connectionInfo, long timeout) {
        try {
            this.availabilityGuard.assertDatabaseAvailable();
            return this.database.getKernel().beginTransaction(type, this.loginContextTransformer.apply(loginContext), connectionInfo, timeout);
        }
        catch (TransactionFailureException | UnavailableException e) {
            throw new org.neo4j.graphdb.TransactionFailureException(e.getMessage(), e);
        }
    }

    public String databaseName() {
        return this.databaseId().name();
    }

    @Override
    public DependencyResolver getDependencyResolver() {
        return this.database.getDependencyResolver();
    }

    @Override
    public DatabaseLayout databaseLayout() {
        return this.database.getDatabaseLayout();
    }

    public String toString() {
        return this.dbmsInfo + " [" + this.databaseLayout() + "]";
    }
}

