/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.staging.ProcessContext;
import org.neo4j.internal.batchimport.staging.PullingProducerStep;
import org.neo4j.internal.batchimport.staging.StageControl;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.transaction.state.storeview.EntityIdIterator;
import org.neo4j.lock.AcquireLockTimeoutException;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class ReadEntityIdsStep
extends PullingProducerStep<ReadEntityProcessContext> {
    private static final String CURSOR_TRACER_TAG = "indexPopulationReadEntityIds";
    private final StoreScan.ExternalUpdatesCheck externalUpdatesCheck;
    private final AtomicBoolean continueScanning;
    private final BiFunction<CursorContext, StoreCursors, EntityIdIterator> entityIdIteratorSupplier;
    private final Function<CursorContext, StoreCursors> storeCursorsFactory;
    private final PageCacheTracer pageCacheTracer;
    private final AtomicLong position = new AtomicLong();
    private volatile long lastEntityId;

    public ReadEntityIdsStep(StageControl control, Configuration configuration, BiFunction<CursorContext, StoreCursors, EntityIdIterator> entityIdIteratorSupplier, Function<CursorContext, StoreCursors> storeCursorsFactory, PageCacheTracer cacheTracer, StoreScan.ExternalUpdatesCheck externalUpdatesCheck, AtomicBoolean continueScanning) {
        super(control, configuration);
        this.entityIdIteratorSupplier = entityIdIteratorSupplier;
        this.storeCursorsFactory = storeCursorsFactory;
        this.pageCacheTracer = cacheTracer;
        this.externalUpdatesCheck = externalUpdatesCheck;
        this.continueScanning = continueScanning;
    }

    protected ReadEntityProcessContext processContext() {
        return new ReadEntityProcessContext(this.pageCacheTracer, this.storeCursorsFactory, this.entityIdIteratorSupplier);
    }

    protected Object nextBatchOrNull(long ticket, int batchSize, ReadEntityProcessContext processContext) {
        if (!this.continueScanning.get() || !processContext.entityIdIterator.hasNext()) {
            return null;
        }
        this.checkAndApplyExternalUpdates(processContext.entityIdIterator);
        long[] entityIds = new long[batchSize];
        int cursor = 0;
        while (cursor < batchSize && processContext.entityIdIterator.hasNext()) {
            entityIds[cursor++] = processContext.entityIdIterator.next();
        }
        this.position.getAndAdd(cursor);
        this.lastEntityId = entityIds[cursor - 1];
        return cursor == entityIds.length ? entityIds : Arrays.copyOf(entityIds, cursor);
    }

    private void checkAndApplyExternalUpdates(EntityIdIterator entityIdIterator) {
        if (this.externalUpdatesCheck.needToApplyExternalUpdates()) {
            long i = 0L;
            while (!this.control.isIdle()) {
                ReadEntityIdsStep.incrementalBackoff(i);
                ++i;
            }
            this.externalUpdatesCheck.applyExternalUpdates(this.lastEntityId);
            entityIdIterator.invalidateCache();
        }
    }

    private static void incrementalBackoff(long iteration) throws AcquireLockTimeoutException {
        if (iteration < 1000L) {
            Thread.onSpinWait();
            return;
        }
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new AcquireLockTimeoutException("Interrupted while waiting.", (Throwable)e, (Status)Status.Transaction.Interrupted);
        }
    }

    protected long position() {
        return this.position.get();
    }

    static class ReadEntityProcessContext
    implements ProcessContext {
        private final CursorContext cursorContext;
        private final StoreCursors storeCursors;
        private final EntityIdIterator entityIdIterator;

        ReadEntityProcessContext(PageCacheTracer cacheTracer, Function<CursorContext, StoreCursors> storeCursorsFactory, BiFunction<CursorContext, StoreCursors, EntityIdIterator> entityIdIteratorSupplier) {
            this.cursorContext = new CursorContext(cacheTracer.createPageCursorTracer(ReadEntityIdsStep.CURSOR_TRACER_TAG));
            this.storeCursors = storeCursorsFactory.apply(this.cursorContext);
            this.entityIdIterator = entityIdIteratorSupplier.apply(this.cursorContext, this.storeCursors);
        }

        public void close() {
            IOUtils.closeAllUnchecked((AutoCloseable[])new AutoCloseable[]{this.entityIdIterator, this.storeCursors, this.cursorContext});
        }
    }
}

