/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.UniqueIndexSampler;
import org.neo4j.kernel.impl.index.schema.CollectingIndexUpdater;
import org.neo4j.kernel.impl.index.schema.ConflictDetectingValueMerger;
import org.neo4j.kernel.impl.index.schema.ConsistencyCheckable;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.DeferredConflictCheckingIndexUpdater;
import org.neo4j.kernel.impl.index.schema.FailureHeaderWriter;
import org.neo4j.kernel.impl.index.schema.FullScanNonUniqueIndexSampler;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.IndexUpdateIgnoreStrategy;
import org.neo4j.kernel.impl.index.schema.NativeIndex;
import org.neo4j.kernel.impl.index.schema.NativeIndexHeaderWriter;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexReader;
import org.neo4j.kernel.impl.index.schema.NativeIndexUpdater;
import org.neo4j.kernel.impl.index.schema.ThrowingConflictDetector;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.util.Preconditions;
import org.neo4j.values.storable.Value;

public abstract class NativeIndexPopulator<KEY extends NativeIndexKey<KEY>>
extends NativeIndex<KEY>
implements IndexPopulator,
ConsistencyCheckable {
    public static final byte BYTE_FAILED = 0;
    static final byte BYTE_ONLINE = 1;
    static final byte BYTE_POPULATING = 2;
    protected final IndexUpdateIgnoreStrategy ignoreStrategy;
    private final KEY treeKey;
    private final UniqueIndexSampler uniqueSampler;
    private ConflictDetectingValueMerger<KEY, Value[]> mainConflictDetector;
    private ConflictDetectingValueMerger<KEY, Value[]> updatesConflictDetector;
    private byte[] failureBytes;
    private boolean dropped;
    private boolean closed;

    NativeIndexPopulator(DatabaseIndexContext databaseIndexContext, IndexFiles indexFiles, IndexLayout<KEY> layout, IndexDescriptor descriptor) {
        super(databaseIndexContext, layout, indexFiles, descriptor);
        this.treeKey = (NativeIndexKey)((Object)layout.newKey());
        this.uniqueSampler = descriptor.isUnique() ? new UniqueIndexSampler() : null;
        this.ignoreStrategy = this.indexUpdateIgnoreStrategy();
    }

    abstract NativeIndexReader<KEY> newReader();

    protected IndexUpdateIgnoreStrategy indexUpdateIgnoreStrategy() {
        return IndexUpdateIgnoreStrategy.NO_IGNORE;
    }

    public synchronized void create() throws IOException {
        this.assertNotDropped();
        this.assertNotClosed();
        this.indexFiles.clear();
        NativeIndexHeaderWriter headerWriter = new NativeIndexHeaderWriter(2);
        this.instantiateTree(RecoveryCleanupWorkCollector.immediate(), headerWriter);
        this.mainConflictDetector = new ThrowingConflictDetector(!this.descriptor.isUnique());
        this.updatesConflictDetector = new ThrowingConflictDetector(true);
    }

    public synchronized void drop() {
        try {
            if (this.tree != null) {
                this.tree.setDeleteOnClose(true);
            }
            this.closeTree();
            this.indexFiles.clear();
        }
        finally {
            this.dropped = true;
            this.closed = true;
        }
    }

    public void add(Collection<? extends IndexEntryUpdate<?>> updates, CursorContext cursorContext) throws IndexEntryConflictException {
        this.processUpdates(updates, this.mainConflictDetector, cursorContext);
    }

    public void verifyDeferredConstraints(NodePropertyAccessor nodePropertyAccessor) {
    }

    public IndexUpdater newPopulatingUpdater(NodePropertyAccessor accessor, CursorContext cursorContext) {
        return this.newPopulatingUpdater(cursorContext);
    }

    IndexUpdater newPopulatingUpdater(CursorContext cursorContext) {
        Object updater = new CollectingIndexUpdater(updates -> this.processUpdates(updates, this.updatesConflictDetector, cursorContext));
        if (this.descriptor.isUnique()) {
            updater = new DeferredConflictCheckingIndexUpdater((IndexUpdater)updater, this::newReader, this.descriptor, cursorContext);
        }
        return updater;
    }

    public synchronized void close(boolean populationCompletedSuccessfully, CursorContext cursorContext) {
        if (populationCompletedSuccessfully && this.failureBytes != null) {
            throw new IllegalStateException("Can't mark index as online after it has been marked as failure");
        }
        try {
            this.assertNotDropped();
            if (populationCompletedSuccessfully) {
                this.assertPopulatorOpen();
                this.flushTreeAndMarkAs((byte)1, cursorContext);
            } else if (this.failureBytes != null) {
                this.ensureTreeInstantiated();
                this.markTreeAsFailed(cursorContext);
            }
        }
        finally {
            this.closeTree();
            this.closed = true;
        }
    }

    public void markAsFailed(String failure) {
        this.failureBytes = failure.getBytes(StandardCharsets.UTF_8);
    }

    public void includeSample(IndexEntryUpdate<?> update) {
        if (this.descriptor.isUnique()) {
            this.updateUniqueSample(update);
        }
    }

    public IndexSample sample(CursorContext cursorContext) {
        if (this.descriptor.isUnique()) {
            return this.uniqueSampler.result();
        }
        return this.buildNonUniqueIndexSample(cursorContext);
    }

    void flushTreeAndMarkAs(byte state, CursorContext cursorContext) {
        this.tree.checkpoint((Consumer)new NativeIndexHeaderWriter(state), cursorContext);
    }

    IndexSample buildNonUniqueIndexSample(CursorContext cursorContext) {
        return new FullScanNonUniqueIndexSampler(this.tree, this.layout).sample(cursorContext, new AtomicBoolean());
    }

    private void markTreeAsFailed(CursorContext cursorContext) {
        Preconditions.checkState((this.failureBytes != null ? 1 : 0) != 0, (String)"markAsFailed hasn't been called, populator not actually failed?");
        this.tree.checkpoint((Consumer)new FailureHeaderWriter(this.failureBytes), cursorContext);
    }

    private void processUpdates(Iterable<? extends IndexEntryUpdate<?>> indexEntryUpdates, ConflictDetectingValueMerger<KEY, Value[]> conflictDetector, CursorContext cursorContext) throws IndexEntryConflictException {
        try (Writer writer = this.tree.writer(cursorContext);){
            for (IndexEntryUpdate<?> indexEntryUpdate : indexEntryUpdates) {
                NativeIndexUpdater.processUpdate(this.treeKey, (ValueIndexEntryUpdate)indexEntryUpdate, writer, conflictDetector, this.ignoreStrategy);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void updateUniqueSample(IndexEntryUpdate<?> update) {
        switch (update.updateMode()) {
            case ADDED: {
                this.uniqueSampler.increment(1L);
                break;
            }
            case REMOVED: {
                this.uniqueSampler.increment(-1L);
                break;
            }
            case CHANGED: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported update mode type:" + update.updateMode());
            }
        }
    }

    private void assertNotDropped() {
        if (this.dropped) {
            throw new IllegalStateException("Populator has already been dropped.");
        }
    }

    private void assertNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("Populator has already been closed.");
        }
    }

    private void ensureTreeInstantiated() {
        if (this.tree == null) {
            this.instantiateTree(RecoveryCleanupWorkCollector.ignore(), GBPTree.NO_HEADER_WRITER);
        }
    }

    private void assertPopulatorOpen() {
        if (this.tree == null) {
            throw new IllegalStateException("Populator has already been closed.");
        }
    }
}

