/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.traversal.BidirectionalUniquenessFilter;
import org.neo4j.graphdb.traversal.BranchCollisionDetector;
import org.neo4j.graphdb.traversal.BranchCollisionPolicy;
import org.neo4j.graphdb.traversal.BranchSelector;
import org.neo4j.graphdb.traversal.BranchState;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.Evaluator;
import org.neo4j.graphdb.traversal.PathEvaluator;
import org.neo4j.graphdb.traversal.SideSelector;
import org.neo4j.graphdb.traversal.SideSelectorPolicy;
import org.neo4j.graphdb.traversal.TraversalBranch;
import org.neo4j.graphdb.traversal.TraversalContext;
import org.neo4j.graphdb.traversal.UniquenessFilter;
import org.neo4j.kernel.impl.traversal.AbstractTraverserIterator;
import org.neo4j.kernel.impl.traversal.AsOneStartBranch;
import org.neo4j.kernel.impl.traversal.MonoDirectionalTraversalDescription;

class BidirectionalTraverserIterator
extends AbstractTraverserIterator {
    private final BranchCollisionDetector collisionDetector;
    private Iterator<Path> foundPaths;
    private SideSelector selector;
    private final Map<Direction, Side> sides = new EnumMap<Direction, Side>(Direction.class);
    private final BidirectionalUniquenessFilter uniqueness;

    BidirectionalTraverserIterator(MonoDirectionalTraversalDescription start, MonoDirectionalTraversalDescription end, SideSelectorPolicy sideSelector, BranchCollisionPolicy collisionPolicy, PathEvaluator collisionEvaluator, int maxDepth, Iterable<Node> startNodes, Iterable<Node> endNodes) {
        this.sides.put(Direction.OUTGOING, new Side(start));
        this.sides.put(Direction.INCOMING, new Side(end));
        this.uniqueness = BidirectionalTraverserIterator.makeSureStartAndEndHasSameUniqueness(start, end);
        this.selector = BidirectionalTraverserIterator.fixedSide(Direction.OUTGOING);
        BranchSelector startSelector = start.branchOrdering.create((TraversalBranch)new AsOneStartBranch(this, startNodes, start.initialState, start.uniqueness), start.expander);
        this.selector = BidirectionalTraverserIterator.fixedSide(Direction.INCOMING);
        BranchSelector endSelector = end.branchOrdering.create((TraversalBranch)new AsOneStartBranch(this, endNodes, end.initialState, start.uniqueness), end.expander);
        this.selector = sideSelector.create(startSelector, endSelector, maxDepth);
        this.collisionDetector = collisionPolicy.create((Evaluator)collisionEvaluator, arg_0 -> ((BidirectionalUniquenessFilter)this.uniqueness).checkFull(arg_0));
    }

    private static BidirectionalUniquenessFilter makeSureStartAndEndHasSameUniqueness(MonoDirectionalTraversalDescription start, MonoDirectionalTraversalDescription end) {
        boolean parameterDiffers;
        if (!start.uniqueness.equals(end.uniqueness)) {
            throw new IllegalArgumentException("Start and end uniqueness factories differ, they need to be the same currently. Start side has " + start.uniqueness + ", end side has " + end.uniqueness);
        }
        boolean bl = start.uniquenessParameter == null || end.uniquenessParameter == null ? start.uniquenessParameter != end.uniquenessParameter : (parameterDiffers = !start.uniquenessParameter.equals(end.uniquenessParameter));
        if (parameterDiffers) {
            throw new IllegalArgumentException("Start and end uniqueness parameters differ, they need to be the same currently. Start side has " + start.uniquenessParameter + ", end side has " + end.uniquenessParameter);
        }
        UniquenessFilter uniqueness = start.uniqueness.create(start.uniquenessParameter);
        if (!(uniqueness instanceof BidirectionalUniquenessFilter)) {
            throw new IllegalArgumentException("You must supply a BidirectionalUniquenessFilter, not just a UniquenessFilter.");
        }
        return (BidirectionalUniquenessFilter)uniqueness;
    }

    private static SideSelector fixedSide(final Direction direction) {
        return new SideSelector(){

            public TraversalBranch next(TraversalContext metadata) {
                throw new UnsupportedOperationException();
            }

            public Direction currentSide() {
                return direction;
            }
        };
    }

    protected Path fetchNextOrNull() {
        if (this.foundPaths != null) {
            if (this.foundPaths.hasNext()) {
                ++this.numberOfPathsReturned;
                return this.foundPaths.next();
            }
            this.foundPaths = null;
        }
        while (true) {
            TraversalBranch result;
            if ((result = this.selector.next((TraversalContext)this)) == null) {
                return null;
            }
            Iterable pathCollisions = this.collisionDetector.evaluate(result, this.selector.currentSide());
            if (pathCollisions == null) continue;
            this.foundPaths = pathCollisions.iterator();
            if (this.foundPaths.hasNext()) break;
        }
        ++this.numberOfPathsReturned;
        return this.foundPaths.next();
    }

    private Side currentSideDescription() {
        return this.sides.get(this.selector.currentSide());
    }

    public Evaluation evaluate(TraversalBranch branch, BranchState state) {
        return this.currentSideDescription().description.evaluator.evaluate((Path)branch, state);
    }

    public boolean isUniqueFirst(TraversalBranch branch) {
        return this.uniqueness.checkFirst(branch);
    }

    public boolean isUnique(TraversalBranch branch) {
        return this.uniqueness.check(branch);
    }

    private static class Side {
        private final MonoDirectionalTraversalDescription description;

        Side(MonoDirectionalTraversalDescription description) {
            this.description = description;
        }
    }
}

