/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.eclipse.collections.api.factory.set.strategy.MutableHashingStrategySetFactory;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.impl.block.factory.HashingStrategies;
import org.eclipse.collections.impl.set.strategy.mutable.MutableHashingStrategySetFactoryImpl;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.exceptions.ResourceCloseFailureException;

public class CloseableResourceManager
implements ResourceTracker {
    private static final MutableHashingStrategySetFactory SET_FACTORY = MutableHashingStrategySetFactoryImpl.INSTANCE;
    private MutableSet<AutoCloseable> closeableResources;

    public final void registerCloseableResource(AutoCloseable closeable) {
        if (this.closeableResources == null) {
            this.closeableResources = SET_FACTORY.withInitialCapacity(HashingStrategies.identityStrategy(), 8);
        }
        this.closeableResources.add((Object)closeable);
    }

    public final void unregisterCloseableResource(AutoCloseable closeable) {
        if (this.closeableResources != null) {
            this.closeableResources.remove((Object)closeable);
        }
    }

    public final void closeAllCloseableResources() {
        if (this.closeableResources != null) {
            MutableSet<AutoCloseable> resources = this.closeableResources;
            this.closeableResources = null;
            IOUtils.close(ResourceCloseFailureException::new, (AutoCloseable[])((AutoCloseable[])resources.toArray(AutoCloseable[]::new)));
        }
    }
}

