/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.internal;

import org.neo4j.graphdb.Entity;
import org.neo4j.internal.helpers.collection.PrefetchingResourceIterator;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.kernel.impl.coreapi.internal.CursorEntityFactory;

abstract class PrefetchingEntityResourceIterator<CURSOR extends Cursor, T extends Entity>
extends PrefetchingResourceIterator<T> {
    private final CURSOR cursor;
    private final CursorEntityFactory<CURSOR, T> entityFactory;
    private boolean closed;
    protected static final long NO_ID = -1L;

    PrefetchingEntityResourceIterator(CURSOR cursor, CursorEntityFactory<CURSOR, T> entityFactory) {
        this.cursor = cursor;
        this.entityFactory = entityFactory;
    }

    protected T fetchNextOrNull() {
        long id = this.fetchNext();
        if (id != -1L) {
            return this.entityFactory.make(this.cursor);
        }
        this.close();
        return null;
    }

    public void close() {
        if (!this.closed) {
            this.closeResources();
            this.closed = true;
        }
    }

    abstract long fetchNext();

    abstract void closeResources();
}

