/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query;

import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.internal.kernel.api.ExecutionStatistics;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.InnerTransactionHandler;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.QueryRegistry;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.factory.KernelTransactionFactory;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.impl.query.statistic.StatisticProvider;
import org.neo4j.kernel.impl.util.DefaultValueMapper;
import org.neo4j.values.ValueMapper;

public class Neo4jTransactionalContext
implements TransactionalContext {
    private final GraphDatabaseQueryService graph;
    public final KernelTransaction.Type transactionType;
    public final SecurityContext securityContext;
    private final ExecutingQuery executingQuery;
    private final ClientConnectionInfo clientInfo;
    private final NamedDatabaseId namedDatabaseId;
    private final InternalTransaction transaction;
    private KernelTransaction kernelTransaction;
    private KernelStatement statement;
    private long userTransactionId;
    private final ValueMapper<Object> valueMapper;
    private final KernelTransactionFactory transactionFactory;
    private volatile boolean isOpen = true;
    private StatisticProvider statisticProvider;

    public Neo4jTransactionalContext(GraphDatabaseQueryService graph, InternalTransaction transaction, KernelStatement initialStatement, ExecutingQuery executingQuery, KernelTransactionFactory transactionFactory) {
        this.graph = graph;
        this.transactionType = transaction.transactionType();
        this.securityContext = transaction.securityContext();
        this.clientInfo = transaction.clientInfo();
        this.executingQuery = executingQuery;
        this.transaction = transaction;
        this.namedDatabaseId = initialStatement.namedDatabaseId();
        this.kernelTransaction = transaction.kernelTransaction();
        this.statement = initialStatement;
        this.userTransactionId = this.kernelTransaction.getUserTransactionId();
        this.valueMapper = new DefaultValueMapper(transaction);
        this.transactionFactory = transactionFactory;
        this.statisticProvider = new TransactionalContextStatisticProvider(this.kernelTransaction.executionStatistics());
    }

    @Override
    public ValueMapper<Object> valueMapper() {
        return this.valueMapper;
    }

    @Override
    public ExecutingQuery executingQuery() {
        return this.executingQuery;
    }

    @Override
    public KernelTransaction kernelTransaction() {
        return this.kernelTransaction;
    }

    @Override
    public InternalTransaction transaction() {
        return this.transaction;
    }

    @Override
    public boolean isTopLevelTx() {
        return this.transaction.transactionType() == KernelTransaction.Type.IMPLICIT;
    }

    @Override
    public void close() {
        if (this.isOpen) {
            try {
                this.statement.queryRegistry().unbindExecutingQuery(this.executingQuery, this.userTransactionId);
                this.statement.close();
            }
            finally {
                this.statement = null;
                this.isOpen = false;
            }
        }
    }

    @Override
    public void rollback() {
        try {
            this.close();
        }
        finally {
            this.transaction.rollback();
        }
    }

    @Override
    public void terminate() {
        if (this.isOpen) {
            this.transaction.terminate();
        }
    }

    @Override
    public long commitAndRestartTx() {
        long l;
        block8: {
            this.checkNotTerminated();
            QueryRegistry oldQueryRegistry = this.statement.queryRegistry();
            KernelStatement oldStatement = this.statement;
            KernelTransaction oldKernelTx = this.transaction.kernelTransaction();
            oldQueryRegistry.unbindExecutingQuery(this.executingQuery, this.userTransactionId);
            this.kernelTransaction = this.transactionFactory.beginKernelTransaction(this.transactionType, (LoginContext)this.securityContext, this.clientInfo);
            this.statement = (KernelStatement)this.kernelTransaction.acquireStatement();
            this.userTransactionId = this.kernelTransaction.getUserTransactionId();
            this.statement.queryRegistry().bindExecutingQuery(this.executingQuery);
            this.transaction.setTransaction(this.kernelTransaction);
            this.updatePeriodicCommitStatisticProvider(this.kernelTransaction);
            oldStatement.close();
            KernelTransaction kernelTransaction = oldKernelTx;
            try {
                l = oldKernelTx.commit();
                if (kernelTransaction == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (kernelTransaction != null) {
                        try {
                            kernelTransaction.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    this.transaction.rollback();
                    throw new RuntimeException(t);
                }
            }
            kernelTransaction.close();
        }
        return l;
    }

    @Override
    public Neo4jTransactionalContext contextWithNewTransaction() {
        this.checkNotTerminated();
        if (this.transactionType != KernelTransaction.Type.IMPLICIT) {
            throw new TransactionFailureException("A query with 'CALL { ... } IN TRANSACTIONS' can only be executed in an implicit transaction, but tried to execute in an explicit transaction.");
        }
        InternalTransaction newTransaction = this.graph.beginTransaction(this.transactionType, (LoginContext)this.securityContext, this.clientInfo);
        long newTransactionId = newTransaction.kernelTransaction().getUserTransactionId();
        InnerTransactionHandler innerTransactionHandler = this.kernelTransaction.getInnerTransactionHandler();
        innerTransactionHandler.registerInnerTransaction(newTransactionId);
        newTransaction.addCloseCallback(() -> innerTransactionHandler.removeInnerTransaction(newTransactionId));
        KernelStatement newStatement = (KernelStatement)newTransaction.kernelTransaction().acquireStatement();
        newStatement.queryRegistry().bindExecutingQuery(this.executingQuery);
        return new Neo4jTransactionalContext(this.graph, newTransaction, newStatement, this.executingQuery, this.transactionFactory);
    }

    @Override
    public TransactionalContext getOrBeginNewIfClosed() {
        this.checkNotTerminated();
        if (!this.isOpen) {
            this.statement = (KernelStatement)this.kernelTransaction.acquireStatement();
            this.statement.queryRegistry().bindExecutingQuery(this.executingQuery);
            this.isOpen = true;
        }
        return this;
    }

    private void checkNotTerminated() {
        this.transaction.terminationReason().ifPresent(status -> {
            throw new TransactionTerminatedException(status);
        });
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public GraphDatabaseQueryService graph() {
        return this.graph;
    }

    @Override
    public NamedDatabaseId databaseId() {
        return this.namedDatabaseId;
    }

    @Override
    public Statement statement() {
        return this.statement;
    }

    @Override
    public KernelTransaction.Revertable restrictCurrentTransaction(SecurityContext context) {
        return this.transaction.overrideWith(context);
    }

    @Override
    public SecurityContext securityContext() {
        return this.securityContext;
    }

    @Override
    public ResourceTracker resourceTracker() {
        return this.statement;
    }

    @Override
    public StatisticProvider kernelStatisticProvider() {
        return this.statisticProvider;
    }

    private void updatePeriodicCommitStatisticProvider(KernelTransaction kernelTransaction) {
        this.statisticProvider = new PeriodicCommitTransactionalContextStatisticProvider(kernelTransaction.executionStatistics());
    }

    private class PeriodicCommitTransactionalContextStatisticProvider
    implements StatisticProvider {
        private final ExecutionStatistics executionStatistics;

        private PeriodicCommitTransactionalContextStatisticProvider(ExecutionStatistics executionStatistics) {
            this.executionStatistics = executionStatistics;
        }

        @Override
        public long getPageCacheHits() {
            return this.executionStatistics.pageHits() + Neo4jTransactionalContext.this.executingQuery.pageHitsOfClosedTransactions();
        }

        @Override
        public long getPageCacheMisses() {
            return this.executionStatistics.pageFaults() + Neo4jTransactionalContext.this.executingQuery.pageFaultsOfClosedTransactions();
        }
    }

    private static class TransactionalContextStatisticProvider
    implements StatisticProvider {
        private final ExecutionStatistics executionStatistics;

        private TransactionalContextStatisticProvider(ExecutionStatistics executionStatistics) {
            this.executionStatistics = executionStatistics;
        }

        @Override
        public long getPageCacheHits() {
            return this.executionStatistics.pageHits();
        }

        @Override
        public long getPageCacheMisses() {
            return this.executionStatistics.pageFaults();
        }
    }

    @FunctionalInterface
    static interface Creator {
        public Neo4jTransactionalContext create(InternalTransaction var1, KernelStatement var2, ExecutingQuery var3);
    }
}

