/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.io.IOException;
import org.neo4j.internal.helpers.collection.LruCache;
import org.neo4j.kernel.impl.transaction.log.LogFileInformation;
import org.neo4j.kernel.impl.transaction.log.LogHeaderCache;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesContext;

public class TransactionLogFileInformation
implements LogFileInformation {
    private final LogFiles logFiles;
    private final LogHeaderCache logHeaderCache;
    private final TransactionLogFileTimestampMapper logFileTimestampMapper;
    private final TransactionLogFilesContext logFileContext;

    TransactionLogFileInformation(LogFiles logFiles, LogHeaderCache logHeaderCache, TransactionLogFilesContext context) {
        this.logFiles = logFiles;
        this.logHeaderCache = logHeaderCache;
        this.logFileContext = context;
        this.logFileTimestampMapper = new TransactionLogFileTimestampMapper(logFiles, context.getLogEntryReader());
    }

    @Override
    public long getFirstExistingEntryId() throws IOException {
        LogFile logFile = this.logFiles.getLogFile();
        long version = logFile.getHighestLogVersion();
        long candidateFirstTx = -1L;
        while (logFile.versionExists(version)) {
            candidateFirstTx = this.getFirstEntryId(version);
            --version;
        }
        return logFile.hasAnyEntries(++version) ? candidateFirstTx : -1L;
    }

    @Override
    public long getFirstEntryId(long version) throws IOException {
        LogHeader logHeader = this.logHeaderCache.getLogHeader(version);
        if (logHeader != null) {
            return logHeader.getLastCommittedTxId() + 1L;
        }
        LogFile logFile = this.logFiles.getLogFile();
        if (logFile.versionExists(version)) {
            logHeader = logFile.extractHeader(version);
            this.logHeaderCache.putHeader(version, logHeader);
            return logHeader.getLastCommittedTxId() + 1L;
        }
        return -1L;
    }

    @Override
    public long getLastEntryId() {
        return this.logFileContext.getLastCommittedTransactionId();
    }

    @Override
    public long committingEntryId() {
        return this.logFileContext.committingTransactionId();
    }

    @Override
    public long getFirstStartRecordTimestamp(long version) throws IOException {
        return this.logFileTimestampMapper.getTimestampForVersion(version);
    }

    private static class TransactionLogFileTimestampMapper {
        private static final String FIRST_TRANSACTION_TIME = "First Transaction Time";
        private final LogFiles logFiles;
        private final LogEntryReader logEntryReader;
        private final LruCache<Long, Long> logFileTimeStamp = new LruCache("First Transaction Time", 10000);

        TransactionLogFileTimestampMapper(LogFiles logFiles, LogEntryReader logEntryReader) {
            this.logFiles = logFiles;
            this.logEntryReader = logEntryReader;
        }

        long getTimestampForVersion(long version) throws IOException {
            Long cachedTimeStamp = (Long)this.logFileTimeStamp.get((Object)version);
            if (cachedTimeStamp != null) {
                return cachedTimeStamp;
            }
            LogFile logFile = this.logFiles.getLogFile();
            LogPosition position = logFile.extractHeader(version).getStartPosition();
            try (ReadableLogChannel channel = logFile.getRawReader(position);){
                LogEntry entry;
                while ((entry = this.logEntryReader.readLogEntry((ReadableClosablePositionAwareChecksumChannel)channel)) != null) {
                    if (!(entry instanceof LogEntryStart)) continue;
                    long timeWritten = ((LogEntryStart)entry).getTimeWritten();
                    this.logFileTimeStamp.put((Object)version, (Object)timeWritten);
                    long l = timeWritten;
                    return l;
                }
            }
            return -1L;
        }
    }
}

