/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.util.concurrent.atomic.LongAdder;

public interface DatabaseOperationCounts {
    public long startCount();

    public long createCount();

    public long stopCount();

    public long dropCount();

    public long failedCount();

    public long recoveredCount();

    public static class Counter
    implements DatabaseOperationCounts {
        private final LongAdder createCount = new LongAdder();
        private final LongAdder startCount = new LongAdder();
        private final LongAdder stopCount = new LongAdder();
        private final LongAdder dropCount = new LongAdder();
        private final LongAdder failedCount = new LongAdder();
        private final LongAdder recoveredCount = new LongAdder();

        @Override
        public long startCount() {
            return this.startCount.sum();
        }

        @Override
        public long createCount() {
            return this.createCount.sum();
        }

        @Override
        public long stopCount() {
            return this.stopCount.sum();
        }

        @Override
        public long dropCount() {
            return this.dropCount.sum();
        }

        @Override
        public long failedCount() {
            return this.failedCount.sum();
        }

        @Override
        public long recoveredCount() {
            return this.recoveredCount.sum();
        }

        public void increaseCreateCount() {
            this.createCount.increment();
        }

        public void increaseStartCount() {
            this.startCount.increment();
        }

        public void increaseStopCount() {
            this.stopCount.increment();
        }

        public void increaseDropCount() {
            this.dropCount.increment();
        }

        public void increaseFailedCount() {
            this.failedCount.increment();
        }

        public void increaseRecoveredCount() {
            this.recoveredCount.increment();
        }
    }
}

