/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.database;

import java.io.IOException;
import java.nio.file.Path;
import org.neo4j.dbms.api.DatabaseNotFoundException;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileSystemUtils;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.api.database.DatabaseSizeService;
import org.neo4j.kernel.database.AbstractDatabase;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.database.NamedDatabaseId;

public class DatabaseSizeServiceImpl
implements DatabaseSizeService {
    private final DatabaseContextProvider<? extends DatabaseContext> databaseContextProvider;

    public DatabaseSizeServiceImpl(DatabaseContextProvider<?> databaseContextProvider) {
        this.databaseContextProvider = databaseContextProvider;
    }

    @Override
    public long getDatabaseTotalSize(NamedDatabaseId databaseId) throws IOException {
        AbstractDatabase abstractDatabase = this.getDatabase(databaseId);
        if (abstractDatabase instanceof Database) {
            Database database = (Database)abstractDatabase;
            FileSystemAbstraction fs = DatabaseSizeServiceImpl.getFileSystem(database);
            return DatabaseSizeServiceImpl.getTotalSize(fs, database.getDatabaseLayout());
        }
        return 0L;
    }

    @Override
    public long getDatabaseDataSize(NamedDatabaseId databaseId) throws IOException {
        AbstractDatabase abstractDatabase = this.getDatabase(databaseId);
        if (abstractDatabase instanceof Database) {
            Database database = (Database)abstractDatabase;
            FileSystemAbstraction fs = DatabaseSizeServiceImpl.getFileSystem(database);
            return DatabaseSizeServiceImpl.getDataDirectorySize(fs, database.getDatabaseLayout());
        }
        return 0L;
    }

    @Override
    public long getDatabaseAvailableReservedSize(NamedDatabaseId databaseId) throws IOException {
        AbstractDatabase abstractDatabase = this.getDatabase(databaseId);
        if (abstractDatabase instanceof Database) {
            Database database = (Database)abstractDatabase;
            return database.estimateAvailableReservedSpace();
        }
        return 0L;
    }

    private static FileSystemAbstraction getFileSystem(Database database) {
        return (FileSystemAbstraction)database.getDependencyResolver().resolveDependency(FileSystemAbstraction.class);
    }

    private AbstractDatabase getDatabase(NamedDatabaseId databaseId) {
        return this.databaseContextProvider.getDatabaseContext(databaseId).orElseThrow(() -> new DatabaseNotFoundException("Database " + databaseId.name() + " not found.")).database();
    }

    private static long getTotalSize(FileSystemAbstraction fs, DatabaseLayout databaseLayout) throws IOException {
        long dataDirectorySize = DatabaseSizeServiceImpl.getDataDirectorySize(fs, databaseLayout);
        if (databaseLayout.getTransactionLogsDirectory().equals(databaseLayout.databaseDirectory())) {
            return dataDirectorySize;
        }
        return dataDirectorySize + FileSystemUtils.size((FileSystemAbstraction)fs, (Path)databaseLayout.getTransactionLogsDirectory());
    }

    private static long getDataDirectorySize(FileSystemAbstraction fs, DatabaseLayout databaseLayout) throws IOException {
        return FileSystemUtils.size((FileSystemAbstraction)fs, (Path)databaseLayout.databaseDirectory());
    }
}

