/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.security;

import java.util.Map;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.security.AuthToken;
import org.neo4j.kernel.api.security.exception.InvalidAuthTokenException;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public abstract class AuthManager
extends LifecycleAdapter {
    public static final String INITIAL_USER_NAME = "neo4j";
    public static final String INITIAL_PASSWORD = "neo4j";
    public static final AuthManager NO_AUTH = new AuthManager(){

        @Override
        public LoginContext login(Map<String, Object> authToken, ClientConnectionInfo connectionInfo) {
            AuthToken.clearCredentials(authToken);
            return LoginContext.fullAccess((ClientConnectionInfo)connectionInfo);
        }

        @Override
        public LoginContext impersonate(LoginContext originalAuth, String userToImpersonate) {
            throw new InvalidArgumentException("Impersonation is not supported with auth disabled.");
        }
    };

    public abstract LoginContext login(Map<String, Object> var1, ClientConnectionInfo var2) throws InvalidAuthTokenException;

    public abstract LoginContext impersonate(LoginContext var1, String var2);
}

