/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.diagnostics.providers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.internal.diagnostics.DiagnosticsLogger;
import org.neo4j.internal.diagnostics.DiagnosticsManager;
import org.neo4j.internal.diagnostics.DiagnosticsProvider;
import org.neo4j.io.device.DeviceMapper;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.database.AbstractDatabase;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.diagnostics.providers.ConfigDiagnostics;
import org.neo4j.kernel.diagnostics.providers.PackagingDiagnostics;
import org.neo4j.kernel.diagnostics.providers.StoreFilesDiagnostics;
import org.neo4j.kernel.diagnostics.providers.SystemDiagnostics;
import org.neo4j.kernel.diagnostics.providers.TransactionRangeDiagnostics;
import org.neo4j.kernel.diagnostics.providers.VersionDiagnostics;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.NullLog;
import org.neo4j.logging.internal.LogService;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.server.HeapDumpDiagnostics;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.util.FeatureToggles;

public class DbmsDiagnosticsManager {
    private static final int CONCISE_DATABASE_DUMP_THRESHOLD = FeatureToggles.getInteger(DbmsDiagnosticsManager.class, (String)"conciseDumpThreshold", (int)10);
    private static final int CONCISE_DATABASE_NAMES_PER_ROW = 5;
    private final Dependencies dependencies;
    private final boolean enabled;
    private final InternalLog internalLog;
    private final Boolean splitIntoSections;
    private final JobScheduler jobScheduler;

    public DbmsDiagnosticsManager(Dependencies dependencies, LogService logService) {
        this.internalLog = logService.getInternalLog(DiagnosticsManager.class);
        this.dependencies = dependencies;
        Config config = (Config)dependencies.resolveDependency(Config.class);
        this.enabled = (Boolean)config.get(GraphDatabaseInternalSettings.dump_diagnostics);
        this.splitIntoSections = (Boolean)config.get(GraphDatabaseInternalSettings.split_diagnostics);
        this.jobScheduler = this.splitIntoSections != false ? (JobScheduler)dependencies.resolveDependency(JobScheduler.class) : null;
    }

    public void dumpSystemDiagnostics() {
        if (this.enabled) {
            this.dumpSystemDiagnostics(this.internalLog);
        }
    }

    public void dumpDatabaseDiagnostics(Database database) {
        if (this.enabled) {
            this.dumpDatabaseDiagnostics(database, this.internalLog, false);
        }
    }

    public void dumpAll() {
        this.dumpAll(this.internalLog);
    }

    public void dumpAll(InternalLog log) {
        if (this.enabled) {
            this.dumpSystemDiagnostics(log);
            this.dumpAllDatabases(log);
        }
    }

    private void dumpAllDatabases(InternalLog log) {
        Collection values = this.getDatabaseManager().registeredDatabases().values();
        if (values.size() > CONCISE_DATABASE_DUMP_THRESHOLD) {
            this.dumpConciseDiagnostics(values, log);
        } else {
            values.stream().flatMap(ctx -> ctx.optionalDatabase().stream()).forEach(db -> this.dumpDatabaseDiagnostics((Database)((Object)db), log, true));
        }
    }

    private void dumpConciseDiagnostics(Collection<? extends DatabaseContext> databaseContexts, InternalLog log) {
        List<Database> startedDbs = databaseContexts.stream().flatMap(ctx -> ctx.optionalDatabase().stream()).filter(AbstractDatabase::isStarted).toList();
        List<Database> stoppedDbs = databaseContexts.stream().flatMap(ctx -> ctx.optionalDatabase().stream()).filter(Predicate.not(AbstractDatabase::isStarted)).toList();
        this.dumpAsSingleMessage(log, diagnosticsLogger -> {
            this.logDatabasesState((ExtendedDiagnosticsLogger)diagnosticsLogger, startedDbs, "Started");
            diagnosticsLogger.newSegment();
            this.logDatabasesState((ExtendedDiagnosticsLogger)diagnosticsLogger, stoppedDbs, "Stopped");
        });
    }

    private void logDatabasesState(ExtendedDiagnosticsLogger log, List<Database> databases, String state) {
        DiagnosticsManager.section((DiagnosticsLogger)log, (String)(state + " Databases"));
        if (databases.isEmpty()) {
            log.log(String.format("There are no %s databases", state.toLowerCase()));
            return;
        }
        int lastIndex = 0;
        for (int i = 5; i < databases.size(); i += 5) {
            List<Database> subList = databases.subList(lastIndex, i);
            this.logDatabases(log, subList);
            log.newSegment();
            lastIndex = i;
        }
        List<Database> lastDbs = databases.subList(lastIndex, databases.size());
        log.newSegment();
        this.logDatabases(log, lastDbs);
    }

    private void logDatabases(DiagnosticsLogger log, List<Database> subList) {
        log.log(subList.stream().map(database -> database.getNamedDatabaseId().name()).collect(Collectors.joining(", ")));
    }

    private void dumpSystemDiagnostics(InternalLog log) {
        this.dumpAsSingleMessage(log, diagnosticsLogger -> {
            Config config = (Config)this.dependencies.resolveDependency(Config.class);
            DiagnosticsManager.section((DiagnosticsLogger)diagnosticsLogger, (String)"System diagnostics");
            diagnosticsLogger.newSegment();
            for (SystemDiagnostics diagnostics : SystemDiagnostics.values()) {
                DiagnosticsManager.dump((DiagnosticsProvider)diagnostics, (InternalLog)log, (DiagnosticsLogger)diagnosticsLogger);
                diagnosticsLogger.newSegment();
            }
            diagnosticsLogger.newSegment();
            DiagnosticsManager.dump((DiagnosticsProvider)new ConfigDiagnostics(config), (InternalLog)log, (DiagnosticsLogger)diagnosticsLogger);
            diagnosticsLogger.newSegment();
            DiagnosticsManager.dump((DiagnosticsProvider)new PackagingDiagnostics(config), (InternalLog)log, (DiagnosticsLogger)diagnosticsLogger);
            diagnosticsLogger.newSegment();
            this.dependencies.resolveTypeDependencies(DiagnosticsProvider.class).forEach(provider -> DiagnosticsManager.dump((DiagnosticsProvider)provider, (InternalLog)log, (DiagnosticsLogger)diagnosticsLogger));
            diagnosticsLogger.newSegment();
        });
    }

    private void dumpDatabaseDiagnostics(Database database, InternalLog log, boolean checkStatus) {
        this.dumpAsSingleMessageWithDbPrefix(log, diagnosticsLogger -> {
            DbmsDiagnosticsManager.dumpDatabaseSectionName(database, diagnosticsLogger);
            if (checkStatus) {
                DbmsDiagnosticsManager.logDatabaseStatus(database, diagnosticsLogger);
                diagnosticsLogger.newSegment();
                if (!database.isStarted()) {
                    return;
                }
            }
            DependencyResolver databaseResolver = database.getDependencyResolver();
            DbmsInfo dbmsInfo = (DbmsInfo)((Object)((Object)databaseResolver.resolveDependency(DbmsInfo.class)));
            FileSystemAbstraction fs = (FileSystemAbstraction)databaseResolver.resolveDependency(FileSystemAbstraction.class);
            StorageEngineFactory storageEngineFactory = (StorageEngineFactory)databaseResolver.resolveDependency(StorageEngineFactory.class);
            DeviceMapper deviceMapper = (DeviceMapper)databaseResolver.resolveDependency(DeviceMapper.class);
            StorageEngine storageEngine = (StorageEngine)databaseResolver.resolveDependency(StorageEngine.class);
            DiagnosticsManager.dump((DiagnosticsProvider)new VersionDiagnostics(dbmsInfo, database.getStoreId()), (InternalLog)log, (DiagnosticsLogger)diagnosticsLogger);
            diagnosticsLogger.newSegment();
            DiagnosticsManager.dump((DiagnosticsProvider)new StoreFilesDiagnostics(storageEngineFactory, fs, database.getDatabaseLayout(), deviceMapper), (InternalLog)log, (DiagnosticsLogger)diagnosticsLogger);
            diagnosticsLogger.newSegment();
            DiagnosticsManager.dump((DiagnosticsProvider)new TransactionRangeDiagnostics(database), (InternalLog)log, (DiagnosticsLogger)diagnosticsLogger);
            diagnosticsLogger.newSegment();
            storageEngine.dumpDiagnostics(log, (DiagnosticsLogger)diagnosticsLogger);
            diagnosticsLogger.newSegment();
        }, database.getNamedDatabaseId());
    }

    private void dumpAsSingleMessageWithDbPrefix(InternalLog log, Consumer<ExtendedDiagnosticsLogger> dumpFunction, NamedDatabaseId db) {
        this.dumpAsSingleMessageWithPrefix(log, dumpFunction, "[" + db.logPrefix() + "] ");
    }

    private void dumpAsSingleMessage(InternalLog log, Consumer<ExtendedDiagnosticsLogger> dumpFunction) {
        this.dumpAsSingleMessageWithPrefix(log, dumpFunction, "");
    }

    private void dumpAsSingleMessageWithPrefix(InternalLog log, Consumer<ExtendedDiagnosticsLogger> dumpFunction, String prefix) {
        if (log == NullLog.getInstance()) {
            return;
        }
        ExtendedDiagnosticsLogger diagnosticsLogger = new ExtendedDiagnosticsLogger(prefix);
        dumpFunction.accept(diagnosticsLogger);
        String message = diagnosticsLogger.asMessage();
        HeapDumpDiagnostics.addDiagnostics((String)prefix, (String)message);
        if (this.splitIntoSections.booleanValue()) {
            List<String> segments = diagnosticsLogger.asSegments();
            ArrayList<String> chunksToLog = new ArrayList<String>();
            for (String segment : segments) {
                int chunkSize;
                String[] split = segment.split(System.lineSeparator());
                if (split.length <= (chunkSize = 50)) {
                    chunksToLog.add(segment);
                    continue;
                }
                for (int i = 0; i < split.length; i += chunkSize) {
                    CharSequence[] chunk = Arrays.copyOfRange(split, i, Math.min(i + chunkSize, split.length));
                    chunksToLog.add(String.join((CharSequence)System.lineSeparator(), chunk));
                }
            }
            this.jobScheduler.schedule(Group.LOG_ROTATION, () -> {
                DbmsDiagnosticsManager dbmsDiagnosticsManager = this;
                synchronized (dbmsDiagnosticsManager) {
                    chunksToLog.forEach(arg_0 -> ((InternalLog)log).info(arg_0));
                }
            });
        } else {
            log.info(message);
        }
    }

    private static void logDatabaseStatus(Database database, DiagnosticsLogger log) {
        log.log(String.format("Database is %s.", database.isStarted() ? "started" : "stopped"));
    }

    private static void dumpDatabaseSectionName(Database database, DiagnosticsLogger log) {
        DiagnosticsManager.section((DiagnosticsLogger)log, (String)("Database: " + database.getNamedDatabaseId().name()));
    }

    private DatabaseContextProvider<?> getDatabaseManager() {
        return (DatabaseContextProvider)this.dependencies.resolveDependency(DatabaseContextProvider.class);
    }

    private static class ExtendedDiagnosticsLogger
    implements DiagnosticsLogger {
        private final StringJoiner messages;
        private final List<Integer> segmentIndexes = new ArrayList<Integer>();

        ExtendedDiagnosticsLogger(String prefix) {
            this.messages = new StringJoiner(System.lineSeparator() + " ".repeat(64) + prefix, prefix + System.lineSeparator() + " ".repeat(64) + prefix, "");
        }

        public void log(String logMessage) {
            this.messages.add(logMessage);
        }

        void newSegment() {
            int lastIndex = this.segmentIndexes.isEmpty() ? 0 : this.segmentIndexes.get(this.segmentIndexes.size() - 1);
            int currIndex = this.messages.length();
            if (currIndex > lastIndex) {
                this.segmentIndexes.add(currIndex);
            }
        }

        String asMessage() {
            return this.messages.toString();
        }

        List<String> asSegments() {
            String message = this.asMessage();
            ArrayList<String> segments = new ArrayList<String>();
            int prevIndex = 0;
            for (int index : this.segmentIndexes) {
                segments.add(message.substring(prevIndex, index));
                prevIndex = index;
            }
            String lastMessage = message.substring(prevIndex);
            if (!lastMessage.isEmpty()) {
                segments.add(lastMessage);
            }
            return segments;
        }
    }
}

