/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.neo4j.kernel.impl.index.schema.AbstractArrayType;
import org.neo4j.kernel.impl.index.schema.BooleanArrayType;
import org.neo4j.kernel.impl.index.schema.BooleanType;
import org.neo4j.kernel.impl.index.schema.DateArrayType;
import org.neo4j.kernel.impl.index.schema.DateType;
import org.neo4j.kernel.impl.index.schema.DurationArrayType;
import org.neo4j.kernel.impl.index.schema.DurationType;
import org.neo4j.kernel.impl.index.schema.GeometryArrayType;
import org.neo4j.kernel.impl.index.schema.GeometryType;
import org.neo4j.kernel.impl.index.schema.LocalDateTimeArrayType;
import org.neo4j.kernel.impl.index.schema.LocalDateTimeType;
import org.neo4j.kernel.impl.index.schema.LocalTimeArrayType;
import org.neo4j.kernel.impl.index.schema.LocalTimeType;
import org.neo4j.kernel.impl.index.schema.NumberArrayType;
import org.neo4j.kernel.impl.index.schema.NumberType;
import org.neo4j.kernel.impl.index.schema.TextArrayType;
import org.neo4j.kernel.impl.index.schema.TextType;
import org.neo4j.kernel.impl.index.schema.Type;
import org.neo4j.kernel.impl.index.schema.ZonedDateTimeArrayType;
import org.neo4j.kernel.impl.index.schema.ZonedDateTimeType;
import org.neo4j.kernel.impl.index.schema.ZonedTimeArrayType;
import org.neo4j.kernel.impl.index.schema.ZonedTimeType;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;

class Types {
    static final GeometryType GEOMETRY = new GeometryType(0);
    static final ZonedDateTimeType ZONED_DATE_TIME = new ZonedDateTimeType(1);
    static final LocalDateTimeType LOCAL_DATE_TIME = new LocalDateTimeType(2);
    static final DateType DATE = new DateType(3);
    static final ZonedTimeType ZONED_TIME = new ZonedTimeType(4);
    static final LocalTimeType LOCAL_TIME = new LocalTimeType(5);
    static final DurationType DURATION = new DurationType(6);
    static final TextType TEXT = new TextType(7);
    static final BooleanType BOOLEAN = new BooleanType(8);
    static final NumberType NUMBER = new NumberType(9);
    static final GeometryArrayType GEOMETRY_ARRAY = new GeometryArrayType(10);
    static final ZonedDateTimeArrayType ZONED_DATE_TIME_ARRAY = new ZonedDateTimeArrayType(11);
    static final LocalDateTimeArrayType LOCAL_DATE_TIME_ARRAY = new LocalDateTimeArrayType(12);
    static final DateArrayType DATE_ARRAY = new DateArrayType(13);
    static final ZonedTimeArrayType ZONED_TIME_ARRAY = new ZonedTimeArrayType(14);
    static final LocalTimeArrayType LOCAL_TIME_ARRAY = new LocalTimeArrayType(15);
    static final DurationArrayType DURATION_ARRAY = new DurationArrayType(16);
    static final TextArrayType TEXT_ARRAY = new TextArrayType(17);
    static final BooleanArrayType BOOLEAN_ARRAY = new BooleanArrayType(18);
    static final NumberArrayType NUMBER_ARRAY = new NumberArrayType(19);
    public static final int SIZE_ZONED_DATE_TIME = 16;
    public static final int SIZE_LOCAL_DATE_TIME = 12;
    public static final int SIZE_DATE = 8;
    public static final int SIZE_ZONED_TIME = 12;
    public static final int SIZE_LOCAL_TIME = 8;
    public static final int SIZE_DURATION = 28;
    public static final int SIZE_STRING_LENGTH = 2;
    public static final int SIZE_BOOLEAN = 1;
    public static final int SIZE_NUMBER_TYPE = 1;
    public static final int SIZE_NUMBER_BYTE = 1;
    static final int BIGGEST_REASONABLE_ARRAY_LENGTH = 8192;
    public static final int SIZE_NUMBER_SHORT = 2;
    public static final int SIZE_NUMBER_INT = 4;
    public static final int SIZE_NUMBER_LONG = 8;
    public static final int SIZE_NUMBER_FLOAT = 4;
    public static final int SIZE_NUMBER_DOUBLE = 8;
    public static final int SIZE_ARRAY_LENGTH = 2;

    Types() {
    }

    private static AbstractArrayType<?> typeOf(ValueWriter.ArrayType arrayType, AbstractArrayType<?> geometryArrayType) {
        return switch (arrayType) {
            default -> throw new IncompatibleClassChangeError();
            case ValueWriter.ArrayType.BOOLEAN -> BOOLEAN_ARRAY;
            case ValueWriter.ArrayType.BYTE, ValueWriter.ArrayType.SHORT, ValueWriter.ArrayType.INT, ValueWriter.ArrayType.LONG, ValueWriter.ArrayType.FLOAT, ValueWriter.ArrayType.DOUBLE -> NUMBER_ARRAY;
            case ValueWriter.ArrayType.STRING, ValueWriter.ArrayType.CHAR -> TEXT_ARRAY;
            case ValueWriter.ArrayType.LOCAL_DATE_TIME -> LOCAL_DATE_TIME_ARRAY;
            case ValueWriter.ArrayType.DATE -> DATE_ARRAY;
            case ValueWriter.ArrayType.DURATION -> DURATION_ARRAY;
            case ValueWriter.ArrayType.POINT -> geometryArrayType;
            case ValueWriter.ArrayType.LOCAL_TIME -> LOCAL_TIME_ARRAY;
            case ValueWriter.ArrayType.ZONED_DATE_TIME -> ZONED_DATE_TIME_ARRAY;
            case ValueWriter.ArrayType.ZONED_TIME -> ZONED_TIME_ARRAY;
        };
    }

    private static Type[] instantiateTypes() {
        ArrayList<Type> types = new ArrayList<Type>();
        types.add(GEOMETRY);
        types.add(ZONED_DATE_TIME);
        types.add(LOCAL_DATE_TIME);
        types.add(DATE);
        types.add(ZONED_TIME);
        types.add(LOCAL_TIME);
        types.add(DURATION);
        types.add(TEXT);
        types.add(BOOLEAN);
        types.add(NUMBER);
        types.add(GEOMETRY_ARRAY);
        types.add(ZONED_DATE_TIME_ARRAY);
        types.add(LOCAL_DATE_TIME_ARRAY);
        types.add(DATE_ARRAY);
        types.add(ZONED_TIME_ARRAY);
        types.add(LOCAL_TIME_ARRAY);
        types.add(DURATION_ARRAY);
        types.add(TEXT_ARRAY);
        types.add(BOOLEAN_ARRAY);
        types.add(NUMBER_ARRAY);
        byte expectedTypeId = 0;
        for (Type type : types) {
            if (type.typeId != expectedTypeId) {
                throw new IllegalStateException("The order in this list is not the intended one");
            }
            expectedTypeId = (byte)(expectedTypeId + 1);
        }
        return types.toArray(new Type[0]);
    }

    static class Range {
        static final Type[] BY_ID = Types.instantiateTypes();
        static final Type[] BY_GROUP = new Type[ValueGroup.values().length];
        static final AbstractArrayType[] BY_ARRAY_TYPE = new AbstractArrayType[ValueWriter.ArrayType.values().length];
        static final Type LOWEST_BY_VALUE_GROUP = Collections.min(Arrays.asList(BY_ID), Type.COMPARATOR);
        static final Type HIGHEST_BY_VALUE_GROUP = Collections.max(Arrays.asList(BY_ID), Type.COMPARATOR);

        Range() {
        }

        static {
            Type[] typeArray = BY_ID;
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                Type type;
                Range.BY_GROUP[type.valueGroup.ordinal()] = type = typeArray[i];
            }
            for (Type type : ValueWriter.ArrayType.values()) {
                Range.BY_ARRAY_TYPE[type.ordinal()] = Types.typeOf((ValueWriter.ArrayType)type, GEOMETRY_ARRAY);
            }
        }
    }
}

