/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.security;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.Readables;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.security.URLAccessValidationError;
import org.neo4j.internal.kernel.api.security.SecurityAuthorizationHandler;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.impl.security.URLAccessRule;

public class FileURLAccessRule
implements URLAccessRule {
    private final Configuration config;

    public FileURLAccessRule(Configuration config) {
        this.config = config;
    }

    public URL validate(URL url, SecurityAuthorizationHandler securityAuthorizationHandler, SecurityContext securityContext) throws URLAccessValidationError {
        if (url.getAuthority() != null && !url.getAuthority().equals("")) {
            throw new URLAccessValidationError("file URL may not contain an authority section (i.e. it should be 'file:///')");
        }
        if (url.getQuery() != null && !url.getQuery().equals("")) {
            throw new URLAccessValidationError("file URL may not contain a query component");
        }
        if (!((Boolean)this.config.get(GraphDatabaseSettings.allow_file_urls)).booleanValue()) {
            throw new URLAccessValidationError("configuration property '" + GraphDatabaseSettings.allow_file_urls.name() + "' is false");
        }
        try {
            URI result = this.normalizeURL(url);
            securityAuthorizationHandler.assertLoadAllowed(securityContext, result, null);
            return result.toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private URI normalizeURL(URL url) throws URISyntaxException, URLAccessValidationError {
        if (!((Config)this.config).isExplicitlySet(GraphDatabaseSettings.load_csv_file_url_root)) {
            return url.toURI();
        }
        Path root = (Path)this.config.get(GraphDatabaseSettings.load_csv_file_url_root);
        Path urlPath = Path.of(url.toURI().normalize());
        Path rootPath = root.normalize().toAbsolutePath();
        Path result = rootPath.resolve(urlPath.getRoot().relativize(urlPath)).normalize().toAbsolutePath();
        if (result.startsWith(rootPath)) {
            return result.toUri();
        }
        throw new URLAccessValidationError("file URL points outside configured import directory");
    }

    @Override
    public CharReadable getReader(URL url, SecurityAuthorizationHandler securityAuthorizationHandler, SecurityContext securityContext) throws URLAccessValidationError, IOException {
        try {
            URL validatedURL = this.validate(url, securityAuthorizationHandler, securityContext);
            return Readables.files((Charset)StandardCharsets.UTF_8, (Path[])new Path[]{Paths.get(validatedURL.toURI())});
        }
        catch (URISyntaxException e) {
            throw new URLAccessValidationError("file URL is invalid " + e.getMessage(), (Exception)e);
        }
    }
}

