/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.Flushable;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.io.fs.FlushableChannel;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.io.memory.ScopedBuffer;
import org.neo4j.kernel.impl.transaction.log.FlushableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalFlushableLogChannel;

public class PhysicalFlushableLogPositionAwareChannel
implements FlushableLogPositionAwareChannel {
    private final PhysicalFlushableLogChannel channel;
    private LogVersionedStoreChannel logVersionedStoreChannel;

    public PhysicalFlushableLogPositionAwareChannel(LogVersionedStoreChannel logVersionedStoreChannel, ScopedBuffer buffer) {
        this.logVersionedStoreChannel = logVersionedStoreChannel;
        this.channel = new PhysicalFlushableLogChannel((StoreChannel)logVersionedStoreChannel, buffer);
    }

    public LogPositionMarker getCurrentLogPosition(LogPositionMarker positionMarker) throws IOException {
        positionMarker.mark(this.logVersionedStoreChannel.getLogVersion(), this.channel.position());
        return positionMarker;
    }

    public LogPosition getCurrentLogPosition() throws IOException {
        return new LogPosition(this.logVersionedStoreChannel.getLogVersion(), this.channel.position());
    }

    public void setLogPosition(LogPositionMarker positionMarker) throws IOException {
        if (positionMarker.getLogVersion() != this.logVersionedStoreChannel.getLogVersion()) {
            throw new IllegalArgumentException("Log position points log version %d but the current one is %d".formatted(positionMarker.getLogVersion(), this.logVersionedStoreChannel.getLogVersion()));
        }
        this.logVersionedStoreChannel.position(positionMarker.getByteOffset());
    }

    public Flushable prepareForFlush() throws IOException {
        return this.channel.prepareForFlush();
    }

    public int putChecksum() throws IOException {
        return this.channel.putChecksum();
    }

    public void beginChecksumForWriting() {
        this.channel.beginChecksumForWriting();
    }

    public FlushableChannel put(byte value) throws IOException {
        return this.channel.put(value);
    }

    public FlushableChannel putShort(short value) throws IOException {
        return this.channel.putShort(value);
    }

    public FlushableChannel putInt(int value) throws IOException {
        return this.channel.putInt(value);
    }

    public FlushableChannel putLong(long value) throws IOException {
        return this.channel.putLong(value);
    }

    public FlushableChannel putFloat(float value) throws IOException {
        return this.channel.putFloat(value);
    }

    public FlushableChannel putDouble(double value) throws IOException {
        return this.channel.putDouble(value);
    }

    public FlushableChannel put(byte[] value, int offset, int length) throws IOException {
        return this.channel.put(value, offset, length);
    }

    public FlushableChannel putAll(ByteBuffer src) throws IOException {
        return this.channel.putAll(src);
    }

    public WritableChannel putVersion(byte version) throws IOException {
        return this.channel.putVersion(version);
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public void close() throws IOException {
        this.channel.close();
    }

    public int write(ByteBuffer buffer) throws IOException {
        int remaining = buffer.remaining();
        this.logVersionedStoreChannel.writeAll(buffer);
        return remaining;
    }

    public void setChannel(LogVersionedStoreChannel channel) {
        this.logVersionedStoreChannel = channel;
        this.channel.setChannel((StoreChannel)channel);
    }
}

