/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.time.Clock;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.neo4j.configuration.Config;
import org.neo4j.internal.nativeimpl.NativeAccess;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.BinarySupportedKernelVersions;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.kernel.impl.transaction.log.files.LastClosedPositionProvider;
import org.neo4j.kernel.impl.transaction.log.files.LastCommittedTransactionIdProvider;
import org.neo4j.kernel.impl.transaction.log.files.LogFileVersionTracker;
import org.neo4j.kernel.impl.transaction.log.files.LogVersionRepositoryProvider;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.Monitors;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.StoreId;

public class TransactionLogFilesContext {
    private final AtomicLong rotationThreshold;
    private final long checkpointRotationThreshold;
    private final AtomicBoolean tryPreallocateTransactionLogs;
    private final CommandReaderFactory commandReaderFactory;
    private final LastCommittedTransactionIdProvider lastCommittedTransactionIdSupplier;
    private final LongSupplier committingTransactionIdSupplier;
    private final LastClosedPositionProvider lastClosedPositionProvider;
    private final LogVersionRepositoryProvider logVersionRepositoryProvider;
    private final LogFileVersionTracker versionTracker;
    private final FileSystemAbstraction fileSystem;
    private final InternalLogProvider logProvider;
    private final DatabaseTracers databaseTracers;
    private final NativeAccess nativeAccess;
    private final MemoryTracker memoryTracker;
    private final Monitors monitors;
    private final boolean failOnCorruptedLogFiles;
    private final Supplier<StoreId> storeId;
    private final DatabaseHealth databaseHealth;
    private final KernelVersionProvider kernelVersionProvider;
    private final Clock clock;
    private final String databaseName;
    private final Config config;
    private final LogTailMetadata externalTailInfo;
    private final BinarySupportedKernelVersions binarySupportedKernelVersions;
    private final boolean readOnly;
    private final int envelopeSegmentBlockSizeBytes;
    private final int bufferSizeBytes;

    public TransactionLogFilesContext(AtomicLong rotationThreshold, long checkpointRotationThreshold, AtomicBoolean tryPreallocateTransactionLogs, CommandReaderFactory commandReaderFactory, LastCommittedTransactionIdProvider lastCommittedTransactionIdSupplier, LongSupplier committingTransactionIdSupplier, LastClosedPositionProvider lastClosedPositionProvider, LogVersionRepositoryProvider logVersionRepositoryProvider, LogFileVersionTracker versionTracker, FileSystemAbstraction fileSystem, InternalLogProvider logProvider, DatabaseTracers databaseTracers, Supplier<StoreId> storeId, NativeAccess nativeAccess, MemoryTracker memoryTracker, Monitors monitors, boolean failOnCorruptedLogFiles, DatabaseHealth databaseHealth, KernelVersionProvider kernelVersionProvider, Clock clock, String databaseName, Config config, LogTailMetadata externalTailInfo, BinarySupportedKernelVersions binarySupportedKernelVersions, boolean readOnly, int envelopeSegmentBlockSizeBytes, int bufferSizeBytes) {
        this.rotationThreshold = rotationThreshold;
        this.checkpointRotationThreshold = checkpointRotationThreshold;
        this.tryPreallocateTransactionLogs = tryPreallocateTransactionLogs;
        this.commandReaderFactory = commandReaderFactory;
        this.lastCommittedTransactionIdSupplier = lastCommittedTransactionIdSupplier;
        this.committingTransactionIdSupplier = committingTransactionIdSupplier;
        this.lastClosedPositionProvider = lastClosedPositionProvider;
        this.logVersionRepositoryProvider = logVersionRepositoryProvider;
        this.versionTracker = versionTracker;
        this.fileSystem = fileSystem;
        this.logProvider = logProvider;
        this.databaseTracers = databaseTracers;
        this.storeId = storeId;
        this.nativeAccess = nativeAccess;
        this.memoryTracker = memoryTracker;
        this.monitors = monitors;
        this.failOnCorruptedLogFiles = failOnCorruptedLogFiles;
        this.databaseHealth = databaseHealth;
        this.kernelVersionProvider = kernelVersionProvider;
        this.clock = clock;
        this.databaseName = databaseName;
        this.config = config;
        this.externalTailInfo = externalTailInfo;
        this.binarySupportedKernelVersions = binarySupportedKernelVersions;
        this.readOnly = readOnly;
        this.envelopeSegmentBlockSizeBytes = envelopeSegmentBlockSizeBytes;
        this.bufferSizeBytes = bufferSizeBytes;
    }

    AtomicLong getRotationThreshold() {
        return this.rotationThreshold;
    }

    public long getCheckpointRotationThreshold() {
        return this.checkpointRotationThreshold;
    }

    public CommandReaderFactory getCommandReaderFactory() {
        return this.commandReaderFactory;
    }

    public LogVersionRepositoryProvider getLogVersionRepositoryProvider() {
        return this.logVersionRepositoryProvider;
    }

    public LogFileVersionTracker getLogFileVersionTracker() {
        return this.versionTracker;
    }

    public LastCommittedTransactionIdProvider getLastCommittedTransactionIdProvider() {
        return this.lastCommittedTransactionIdSupplier;
    }

    public long committingTransactionId() {
        return this.committingTransactionIdSupplier.getAsLong();
    }

    LastClosedPositionProvider getLastClosedTransactionPositionProvider() {
        return this.lastClosedPositionProvider;
    }

    public FileSystemAbstraction getFileSystem() {
        return this.fileSystem;
    }

    public InternalLogProvider getLogProvider() {
        return this.logProvider;
    }

    AtomicBoolean getTryPreallocateTransactionLogs() {
        return this.tryPreallocateTransactionLogs;
    }

    public NativeAccess getNativeAccess() {
        return this.nativeAccess;
    }

    public DatabaseTracers getDatabaseTracers() {
        return this.databaseTracers;
    }

    public StoreId getStoreId() {
        return this.storeId.get();
    }

    public MemoryTracker getMemoryTracker() {
        return this.memoryTracker;
    }

    public Monitors getMonitors() {
        return this.monitors;
    }

    public boolean isFailOnCorruptedLogFiles() {
        return this.failOnCorruptedLogFiles;
    }

    public DatabaseHealth getDatabaseHealth() {
        return this.databaseHealth;
    }

    public KernelVersionProvider getKernelVersionProvider() {
        return this.kernelVersionProvider;
    }

    public Clock getClock() {
        return this.clock;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public Config getConfig() {
        return this.config;
    }

    public LogTailMetadata getExternalTailInfo() {
        return this.externalTailInfo;
    }

    public BinarySupportedKernelVersions getBinarySupportedKernelVersions() {
        return this.binarySupportedKernelVersions;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public int getEnvelopeSegmentBlockSizeBytes() {
        return this.envelopeSegmentBlockSizeBytes;
    }

    public int getBufferSizeBytes() {
        return this.bufferSizeBytes;
    }
}

