/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.dbms.database.DbmsRuntimeSystemGraphComponent;
import org.neo4j.dbms.database.DbmsRuntimeVersion;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.util.VisibleForTesting;

public abstract class DbmsRuntimeRepository {
    private final DatabaseContextProvider<?> databaseContextProvider;
    final DbmsRuntimeSystemGraphComponent component;
    private volatile DbmsRuntimeVersion currentVersion;

    protected DbmsRuntimeRepository(DatabaseContextProvider<?> databaseContextProvider, DbmsRuntimeSystemGraphComponent component) {
        this.databaseContextProvider = databaseContextProvider;
        this.component = component;
    }

    protected void fetchStateFromSystemDatabase() {
        GraphDatabaseService systemDatabase = this.getSystemDb();
        this.currentVersion = (DbmsRuntimeVersion)this.component.fetchStateFromSystemDatabase(systemDatabase);
    }

    protected GraphDatabaseService getSystemDb() {
        return ((DatabaseContext)this.databaseContextProvider.getDatabaseContext(NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID).orElseThrow(() -> new RuntimeException("Failed to get System Database"))).databaseFacade();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbmsRuntimeVersion getVersion() {
        if (this.currentVersion == null) {
            DbmsRuntimeRepository dbmsRuntimeRepository = this;
            synchronized (dbmsRuntimeRepository) {
                if (this.currentVersion == null) {
                    this.fetchStateFromSystemDatabase();
                }
            }
        }
        return this.currentVersion;
    }

    @VisibleForTesting
    public void setVersion(DbmsRuntimeVersion newVersion) {
        this.currentVersion = newVersion;
    }
}

