/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import java.util.UUID;
import org.neo4j.common.EntityType;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.values.ElementIdMapper;

public class DefaultElementIdMapperV1
implements ElementIdMapper {
    private static final byte ELEMENT_ID_FORMAT_VERSION = 1;
    private final UUID databaseId;

    public DefaultElementIdMapperV1(NamedDatabaseId databaseId) {
        this.databaseId = databaseId.databaseId().uuid();
    }

    public String nodeElementId(long nodeId) {
        return this.buildElementId(EntityType.NODE, (byte)1, nodeId);
    }

    public long nodeId(String id) {
        return this.decodeElementId(id, EntityType.NODE);
    }

    public String relationshipElementId(long relationshipId) {
        return this.buildElementId(EntityType.RELATIONSHIP, (byte)1, relationshipId);
    }

    public long relationshipId(String id) {
        return this.decodeElementId(id, EntityType.RELATIONSHIP);
    }

    private String buildElementId(EntityType entityType, byte elementIdFormatVersion, long id) {
        return this.buildElementIdByteArrayHeader(entityType, elementIdFormatVersion) + ":" + this.databaseId + ":" + id;
    }

    private long decodeElementId(String id, EntityType entityType) {
        try {
            String[] elements = id.split(":");
            if (elements.length != 3) {
                throw new IllegalArgumentException(String.format("Element ID %s has an unexpected format.", id));
            }
            this.verifyHeader(id, elements[0], entityType);
            this.verifyDatabaseId(elements[1], id);
            return Long.parseLong(elements[2]);
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Element ID %s has an unexpected format.", id), e);
        }
    }

    private void verifyHeader(String id, String headerString, EntityType entityType) {
        byte header = Byte.parseByte(headerString);
        byte version = (byte)(header >>> 2);
        if (version != 1) {
            throw new IllegalArgumentException(String.format("Element ID %s has an unexpected version %d", id, version));
        }
        this.verifyEntityType(id, header, entityType);
    }

    private void verifyDatabaseId(String providedDatabaseId, String id) {
        UUID uuid = UUID.fromString(providedDatabaseId);
        if (!this.databaseId.equals(uuid)) {
            throw new IllegalArgumentException(String.format("Element ID %s does not belong to the current database %s.", id, this.databaseId));
        }
    }

    private void verifyEntityType(String id, byte header, EntityType expected) {
        byte entityTypeId = (byte)(header & 3);
        EntityType entityType = switch (entityTypeId) {
            case 0 -> EntityType.NODE;
            case 1 -> EntityType.RELATIONSHIP;
            default -> throw new IllegalArgumentException(String.format("Element ID %s has unknown entity type ID %s", id, entityTypeId));
        };
        if (entityType != expected) {
            throw new IllegalArgumentException(String.format("Element ID %s has unexpected entity type %s, was expecting %s", id, entityType, expected));
        }
    }

    private byte buildElementIdByteArrayHeader(EntityType entityType, byte version) {
        byte header = 0;
        header = (byte)(header | (entityType != EntityType.NODE ? 1 : 0));
        header = (byte)(header | version << 2);
        return header;
    }
}

