/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.io.pagecache.OutOfDiskSpaceException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.tracing.StoreApplyEvent;
import org.neo4j.storageengine.api.CommandBatchToApply;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.TransactionApplicationMode;

public class InternalTransactionCommitProcess
implements TransactionCommitProcess {
    private final TransactionAppender appender;
    private final StorageEngine storageEngine;
    private final boolean preAllocateSpaceInStores;

    public InternalTransactionCommitProcess(TransactionAppender appender, StorageEngine storageEngine, boolean preAllocateSpaceInStores) {
        this.appender = appender;
        this.storageEngine = storageEngine;
        this.preAllocateSpaceInStores = preAllocateSpaceInStores;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long commit(CommandBatchToApply batch, CommitEvent commitEvent, TransactionApplicationMode mode) throws TransactionFailureException {
        if (this.preAllocateSpaceInStores) {
            this.preAllocateSpaceInStores(batch, commitEvent, mode);
        }
        long lastTxId = this.appendToLog(batch, commitEvent);
        try {
            this.applyToStore(batch, commitEvent, mode);
            long l = lastTxId;
            return l;
        }
        finally {
            InternalTransactionCommitProcess.close(batch);
        }
    }

    private long appendToLog(CommandBatchToApply batch, CommitEvent commitEvent) throws TransactionFailureException {
        LogAppendEvent logAppendEvent = commitEvent.beginLogAppend();
        try {
            long l = this.appender.append(batch, logAppendEvent);
            if (logAppendEvent != null) {
                logAppendEvent.close();
            }
            return l;
        }
        catch (Throwable throwable) {
            try {
                if (logAppendEvent != null) {
                    try {
                        logAppendEvent.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable cause) {
                throw new TransactionFailureException((Status)Status.Transaction.TransactionLogError, cause, "Could not append transaction: " + batch + " to log.", new Object[0]);
            }
        }
    }

    protected void applyToStore(CommandBatchToApply batch, CommitEvent commitEvent, TransactionApplicationMode mode) throws TransactionFailureException {
        try (StoreApplyEvent storeApplyEvent = commitEvent.beginStoreApply();){
            this.storageEngine.apply(batch, mode);
        }
        catch (Throwable cause) {
            throw new TransactionFailureException((Status)Status.Transaction.TransactionCommitFailed, cause, "Could not apply the transaction: " + batch + " to the store after written to log.", new Object[0]);
        }
    }

    private void preAllocateSpaceInStores(CommandBatchToApply batch, CommitEvent commitEvent, TransactionApplicationMode mode) throws TransactionFailureException {
        try {
            this.storageEngine.preAllocateStoreFilesForCommands(batch, mode);
        }
        catch (OutOfDiskSpaceException oods) {
            throw new TransactionFailureException((Status)Status.General.UnknownError, (Throwable)oods, "Could not preallocate disk space for the transaction: " + batch, new Object[0]);
        }
        catch (Throwable cause) {
            throw new TransactionFailureException((Status)Status.Transaction.TransactionCommitFailed, cause, "Could not preallocate disk space for the transaction: " + batch, new Object[0]);
        }
    }

    private static void close(CommandBatchToApply batch) {
        while (batch != null) {
            batch.close();
            batch = batch.next();
        }
    }
}

