/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.chunk;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.neo4j.common.Subject;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.api.chunk.ChunkMetadata;
import org.neo4j.storageengine.api.CommandBatch;
import org.neo4j.storageengine.api.StorageCommand;

public record CommandChunk(List<StorageCommand> commands, ChunkMetadata chunkMetadata) implements CommandBatch
{
    public byte[] additionalHeader() {
        return this.chunkMetadata.additionalData();
    }

    public long getTimeStarted() {
        return this.chunkMetadata.startTimeMillis();
    }

    public long getLatestCommittedTxWhenStarted() {
        return this.chunkMetadata.lastTransactionIdWhenStarted();
    }

    public long getTimeCommitted() {
        return this.chunkMetadata.chunkCommitTime();
    }

    public int getLeaseId() {
        return this.chunkMetadata.leaseId();
    }

    public Subject subject() {
        return this.chunkMetadata.subject();
    }

    public KernelVersion kernelVersion() {
        return this.chunkMetadata.kernelVersion();
    }

    public String toString(boolean includeCommands) {
        return "CommandChunk{commands=" + this.commands + ", chunkMetadata=" + this.chunkMetadata + "}";
    }

    public boolean isLast() {
        return this.chunkMetadata.last();
    }

    public boolean isFirst() {
        return this.chunkMetadata.first();
    }

    public boolean accept(Visitor<StorageCommand, IOException> visitor) throws IOException {
        for (StorageCommand command : this.commands) {
            if (!visitor.visit((Object)command)) continue;
            return true;
        }
        return false;
    }

    public Iterator<StorageCommand> iterator() {
        return this.commands.iterator();
    }
}

