/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.annotations.documented.ReporterFactory;
import org.neo4j.common.DependencyResolver;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.GBPTreeConsistencyCheckVisitor;
import org.neo4j.index.internal.gbptree.MultiRootGBPTree;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.index.schema.ConsistencyCheckable;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.IndexMonitorAdaptor;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NullValue;
import org.neo4j.monitoring.Monitors;

abstract class NativeIndex<KEY extends NativeIndexKey<KEY>>
implements ConsistencyCheckable {
    final PageCache pageCache;
    final IndexFiles indexFiles;
    final IndexLayout<KEY> layout;
    final FileSystemAbstraction fileSystem;
    final IndexDescriptor descriptor;
    private final Monitors monitors;
    private final String monitorTag;
    private final DatabaseReadOnlyChecker readOnlyChecker;
    final String databaseName;
    private final CursorContextFactory contextFactory;
    private final ImmutableSet<OpenOption> openOptions;
    final PageCacheTracer pageCacheTracer;
    private final DependencyResolver dependencyResolver;
    protected GBPTree<KEY, NullValue> tree;

    NativeIndex(DatabaseIndexContext databaseIndexContext, IndexLayout<KEY> layout, IndexFiles indexFiles, IndexDescriptor descriptor, ImmutableSet<OpenOption> openOptions) {
        this.pageCache = databaseIndexContext.pageCache;
        this.fileSystem = databaseIndexContext.fileSystem;
        this.monitors = databaseIndexContext.monitors;
        this.monitorTag = databaseIndexContext.monitorTag;
        this.readOnlyChecker = databaseIndexContext.readOnlyChecker;
        this.databaseName = databaseIndexContext.databaseName;
        this.contextFactory = databaseIndexContext.contextFactory;
        this.pageCacheTracer = databaseIndexContext.pageCacheTracer;
        this.dependencyResolver = databaseIndexContext.dependencyResolver;
        this.indexFiles = indexFiles;
        this.layout = layout;
        this.descriptor = descriptor;
        this.openOptions = openOptions;
    }

    void instantiateTree(RecoveryCleanupWorkCollector recoveryCleanupWorkCollector) {
        this.ensureDirectoryExist();
        MultiRootGBPTree.Monitor monitor = this.treeMonitor();
        Path storeFile = this.indexFiles.getStoreFile();
        this.tree = new GBPTree(this.pageCache, this.fileSystem, storeFile, this.layout, monitor, GBPTree.NO_HEADER_READER, recoveryCleanupWorkCollector, false, this.openOptions, this.databaseName, this.descriptor.getName(), this.contextFactory, this.pageCacheTracer, this.dependencyResolver);
        this.afterTreeInstantiation(this.tree);
    }

    protected void assertWritable() {
        if (this.readOnlyChecker.isReadOnly()) {
            throw new UnsupportedOperationException("Database currently is in read only mode and can not perform writes");
        }
    }

    protected void afterTreeInstantiation(GBPTree<KEY, NullValue> tree) {
    }

    private MultiRootGBPTree.Monitor treeMonitor() {
        MultiRootGBPTree.Monitor treeMonitor = (MultiRootGBPTree.Monitor)this.monitors.newMonitor(MultiRootGBPTree.Monitor.class, new String[]{this.monitorTag});
        IndexProvider.Monitor indexMonitor = (IndexProvider.Monitor)this.monitors.newMonitor(IndexProvider.Monitor.class, new String[]{this.monitorTag});
        return new IndexMonitorAdaptor(treeMonitor, indexMonitor, this.indexFiles, this.descriptor);
    }

    private void ensureDirectoryExist() {
        this.indexFiles.ensureDirectoryExist();
    }

    void closeTree() {
        IOUtils.closeAllUnchecked((AutoCloseable[])new GBPTree[]{this.tree});
        this.tree = null;
    }

    void assertOpen() {
        if (this.tree == null) {
            throw new IllegalStateException("Index has been closed");
        }
    }

    public boolean consistencyCheck(ReporterFactory reporterFactory, CursorContextFactory contextFactory, int numThreads) {
        return this.consistencyCheck((GBPTreeConsistencyCheckVisitor)reporterFactory.getClass(GBPTreeConsistencyCheckVisitor.class), contextFactory, numThreads);
    }

    private boolean consistencyCheck(GBPTreeConsistencyCheckVisitor visitor, CursorContextFactory contextFactory, int numThreads) {
        try {
            return this.tree.consistencyCheck(visitor, contextFactory, numThreads);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

