/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.nio.file.OpenOption;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexValueValidator;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.GenericIndexKeyValidator;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexAccessor;
import org.neo4j.kernel.impl.index.schema.NullValue;
import org.neo4j.kernel.impl.index.schema.RangeIndexReader;
import org.neo4j.kernel.impl.index.schema.RangeKey;
import org.neo4j.values.storable.Value;

public class RangeIndexAccessor
extends NativeIndexAccessor<RangeKey> {
    private final TokenNameLookup tokenNameLookup;
    private IndexValueValidator validator;

    RangeIndexAccessor(DatabaseIndexContext databaseIndexContext, IndexFiles indexFiles, IndexLayout<RangeKey> layout, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, IndexDescriptor descriptor, TokenNameLookup tokenNameLookup, ImmutableSet<OpenOption> openOptions) {
        super(databaseIndexContext, indexFiles, layout, descriptor, openOptions);
        this.tokenNameLookup = tokenNameLookup;
        this.instantiateTree(recoveryCleanupWorkCollector);
    }

    @Override
    protected void afterTreeInstantiation(GBPTree<RangeKey, NullValue> tree) {
        this.validator = new GenericIndexKeyValidator(tree.keyValueSizeCap(), this.descriptor, (Layout<? extends GenericKey<?>, NullValue>)this.layout, this.tokenNameLookup);
    }

    @Override
    public ValueIndexReader newValueReader() {
        this.assertOpen();
        return new RangeIndexReader((GBPTree<RangeKey, NullValue>)this.tree, this.layout, this.descriptor);
    }

    public void validateBeforeCommit(long entityId, Value[] tuple) {
        this.validator.validate(entityId, tuple);
    }
}

