/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Iterator;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.PopulationProgress;
import org.neo4j.internal.kernel.api.SchemaReadCore;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.impl.newapi.AllStoreHolder;
import org.neo4j.storageengine.api.StorageSchemaReader;

class SchemaReadCoreSnapshot
implements SchemaReadCore {
    private final StorageSchemaReader snapshot;
    private final AllStoreHolder stores;

    SchemaReadCoreSnapshot(StorageSchemaReader snapshot, AllStoreHolder stores) {
        this.snapshot = snapshot;
        this.stores = stores;
    }

    public IndexDescriptor indexGetForName(String name) {
        return this.stores.indexGetForName(this.snapshot, name);
    }

    public ConstraintDescriptor constraintGetForName(String name) {
        return this.stores.constraintGetForName(this.snapshot, name);
    }

    public Iterator<IndexDescriptor> index(SchemaDescriptor schema) {
        this.stores.performCheckBeforeOperation();
        return this.stores.indexGetForSchema(this.snapshot, schema);
    }

    public IndexDescriptor index(SchemaDescriptor schema, IndexType type) {
        this.stores.performCheckBeforeOperation();
        return this.stores.index(schema, type);
    }

    public Iterator<IndexDescriptor> indexesGetForLabel(int labelId) {
        this.stores.performCheckBeforeOperation();
        return this.stores.indexesGetForLabel(this.snapshot, labelId);
    }

    public Iterator<IndexDescriptor> indexesGetForRelationshipType(int relationshipType) {
        this.stores.performCheckBeforeOperation();
        return this.stores.indexesGetForRelationshipType(this.snapshot, relationshipType);
    }

    public Iterator<IndexDescriptor> indexesGetAll() {
        this.stores.performCheckBeforeOperation();
        return this.stores.indexesGetAll(this.snapshot);
    }

    public InternalIndexState indexGetState(IndexDescriptor index) throws IndexNotFoundKernelException {
        AllStoreHolder.assertValidIndex(index);
        this.stores.performCheckBeforeOperation();
        return this.stores.indexGetStateLocked(index);
    }

    public InternalIndexState indexGetStateNonLocking(IndexDescriptor index) throws IndexNotFoundKernelException {
        return this.indexGetState(index);
    }

    public PopulationProgress indexGetPopulationProgress(IndexDescriptor index) throws IndexNotFoundKernelException {
        AllStoreHolder.assertValidIndex(index);
        this.stores.performCheckBeforeOperation();
        return this.stores.indexGetPopulationProgressLocked(index);
    }

    public String indexGetFailure(IndexDescriptor index) throws IndexNotFoundKernelException {
        AllStoreHolder.assertValidIndex(index);
        return this.stores.indexGetFailure(index);
    }

    public Iterator<ConstraintDescriptor> constraintsGetForLabel(int labelId) {
        this.stores.performCheckBeforeOperation();
        return this.stores.constraintsGetForLabel(this.snapshot, labelId);
    }

    public Iterator<ConstraintDescriptor> constraintsGetForLabelNonLocking(int labelId) {
        return this.constraintsGetForLabel(labelId);
    }

    public Iterator<ConstraintDescriptor> constraintsGetForRelationshipType(int typeId) {
        this.stores.performCheckBeforeOperation();
        return this.stores.constraintsGetForRelationshipType(this.snapshot, typeId);
    }

    public Iterator<ConstraintDescriptor> constraintsGetForRelationshipTypeNonLocking(int typeId) {
        return this.constraintsGetForRelationshipType(typeId);
    }

    public Iterator<ConstraintDescriptor> constraintsGetAll() {
        this.stores.performCheckBeforeOperation();
        return this.stores.constraintsGetAll(this.snapshot);
    }

    public Iterator<ConstraintDescriptor> constraintsGetAllNonLocking() {
        return this.constraintsGetAll();
    }
}

