/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import org.neo4j.kernel.impl.transaction.CommittedCommandBatch;
import org.neo4j.kernel.impl.transaction.log.CommandBatchCursor;
import org.neo4j.kernel.impl.transaction.log.LogEntryCursor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.v54.LogEntryChunkStart;

public class SketchingCommandBatchCursor
implements CommandBatchCursor {
    private final ReadableClosablePositionAwareChecksumChannel channel;
    private final LogEntryCursor logEntryCursor;
    private final LogPositionMarker lastGoodPositionMarker = new LogPositionMarker();

    public SketchingCommandBatchCursor(ReadableClosablePositionAwareChecksumChannel channel, LogEntryReader entryReader) throws IOException {
        this.channel = channel;
        channel.getCurrentPosition(this.lastGoodPositionMarker);
        this.logEntryCursor = new LogEntryCursor(entryReader, channel);
    }

    public CommittedCommandBatch get() {
        throw new UnsupportedOperationException();
    }

    public boolean next() throws IOException {
        if (this.hasEntries()) {
            LogEntry entry = this.logEntryCursor.get();
            assert (entry instanceof LogEntryStart || entry instanceof LogEntryChunkStart) : "Expected Start entry, read " + entry + " instead";
            while (this.hasEntries()) {
                entry = this.logEntryCursor.get();
                if (!this.isBatchEnd(entry)) continue;
                this.channel.getCurrentPosition(this.lastGoodPositionMarker);
                return true;
            }
        }
        return false;
    }

    private boolean hasEntries() throws IOException {
        return this.logEntryCursor.next();
    }

    private boolean isBatchEnd(LogEntry entry) {
        return SketchingCommandBatchCursor.isChunkEnd(entry) || SketchingCommandBatchCursor.isCommit(entry);
    }

    private static boolean isCommit(LogEntry entry) {
        return entry.getType() == 5;
    }

    private static boolean isChunkEnd(LogEntry entry) {
        return entry.getType() == 11;
    }

    public void close() throws IOException {
        this.logEntryCursor.close();
    }

    @Override
    public LogPosition position() {
        return this.lastGoodPositionMarker.newPosition();
    }
}

