/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.storageengine.api.Commitment;
import org.neo4j.storageengine.api.TransactionIdStore;

public class TransactionCommitment
implements Commitment {
    private final TransactionMetadataCache transactionMetadataCache;
    private final TransactionIdStore transactionIdStore;
    private boolean committed;
    private long transactionId;
    private int checksum;
    private LogPosition logPosition;
    private long transactionCommitTimestamp;

    TransactionCommitment(TransactionMetadataCache transactionMetadataCache, TransactionIdStore transactionIdStore) {
        this.transactionMetadataCache = transactionMetadataCache;
        this.transactionIdStore = transactionIdStore;
    }

    public void commit(long transactionId, LogPosition beforeCommit, LogPosition logPositionAfterCommit, int checksum) {
        this.transactionId = transactionId;
        this.logPosition = logPositionAfterCommit;
        this.checksum = checksum;
        this.transactionMetadataCache.cacheTransactionMetadata(transactionId, beforeCommit);
    }

    public void publishAsCommitted(long transactionCommitTimestamp) {
        this.committed = true;
        this.transactionCommitTimestamp = transactionCommitTimestamp;
        this.transactionIdStore.transactionCommitted(this.transactionId, this.checksum, transactionCommitTimestamp);
    }

    public void publishAsClosed() {
        if (this.committed) {
            this.transactionIdStore.transactionClosed(this.transactionId, this.logPosition.getLogVersion(), this.logPosition.getByteOffset(), this.checksum, this.transactionCommitTimestamp);
        }
    }
}

