/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.impl.transaction.CommittedCommandBatch;
import org.neo4j.kernel.impl.transaction.log.CommandBatchCursor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.recovery.ParallelRecoveryVisitor;
import org.neo4j.kernel.recovery.RecoveryApplier;
import org.neo4j.kernel.recovery.RecoveryService;
import org.neo4j.kernel.recovery.RecoveryStartInformation;
import org.neo4j.kernel.recovery.RecoveryStartInformationProvider;
import org.neo4j.kernel.recovery.RecoveryVisitor;
import org.neo4j.logging.InternalLog;
import org.neo4j.storageengine.api.ClosedTransactionMetadata;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.TransactionIdStore;

public class DefaultRecoveryService
implements RecoveryService {
    private final RecoveryStartInformationProvider recoveryStartInformationProvider;
    private final StorageEngine storageEngine;
    private final TransactionIdStore transactionIdStore;
    private final LogicalTransactionStore logicalTransactionStore;
    private final LogVersionRepository logVersionRepository;
    private final InternalLog log;
    private final boolean doParallelRecovery;

    DefaultRecoveryService(StorageEngine storageEngine, TransactionIdStore transactionIdStore, LogicalTransactionStore logicalTransactionStore, LogVersionRepository logVersionRepository, LogFiles logFiles, RecoveryStartInformationProvider.Monitor monitor, InternalLog log, boolean doParallelRecovery) {
        this.storageEngine = storageEngine;
        this.transactionIdStore = transactionIdStore;
        this.logicalTransactionStore = logicalTransactionStore;
        this.logVersionRepository = logVersionRepository;
        this.log = log;
        this.doParallelRecovery = doParallelRecovery;
        this.recoveryStartInformationProvider = new RecoveryStartInformationProvider(logFiles, monitor);
    }

    @Override
    public RecoveryStartInformation getRecoveryStartInformation() {
        return this.recoveryStartInformationProvider.get();
    }

    @Override
    public RecoveryApplier getRecoveryApplier(TransactionApplicationMode mode, CursorContextFactory contextFactory, String tracerTag) {
        if (this.doParallelRecovery) {
            return new ParallelRecoveryVisitor(this.storageEngine, mode, contextFactory, tracerTag);
        }
        return new RecoveryVisitor(this.storageEngine, mode, contextFactory, tracerTag);
    }

    @Override
    public CommandBatchCursor getCommandBatches(long transactionId) throws IOException {
        return this.logicalTransactionStore.getCommandBatches(transactionId);
    }

    @Override
    public CommandBatchCursor getCommandBatches(LogPosition position) throws IOException {
        return this.logicalTransactionStore.getCommandBatches(position);
    }

    @Override
    public CommandBatchCursor getCommandBatchesInReverseOrder(LogPosition position) throws IOException {
        return this.logicalTransactionStore.getCommandBatchesInReverseOrder(position);
    }

    @Override
    public void transactionsRecovered(CommittedCommandBatch lastRecoveredBatch, LogPosition lastRecoveredTransactionPosition, LogPosition positionAfterLastRecoveredTransaction, LogPosition checkpointPosition, boolean missingLogs, CursorContext cursorContext) {
        if (missingLogs) {
            ClosedTransactionMetadata lastClosedTransactionData = this.transactionIdStore.getLastClosedTransaction();
            long logVersion = lastClosedTransactionData.logPosition().getLogVersion();
            this.log.warn("Recovery detected that transaction logs were missing. Resetting offset of last closed transaction to point to the head of %d transaction log file.", new Object[]{logVersion});
            this.transactionIdStore.resetLastClosedTransaction(lastClosedTransactionData.transactionId(), logVersion, 128L, lastClosedTransactionData.checksum(), lastClosedTransactionData.commitTimestamp());
            this.logVersionRepository.setCurrentLogVersion(logVersion);
            long checkpointLogVersion = this.logVersionRepository.getCheckpointLogVersion();
            if (checkpointLogVersion < 0L) {
                this.log.warn("Recovery detected that checkpoint log version is invalid. Resetting version to start from the beginning. Current recorded version: %d. New version: 0.", new Object[]{checkpointLogVersion});
                this.logVersionRepository.setCheckpointLogVersion(0L);
            }
            return;
        }
        if (lastRecoveredBatch != null) {
            this.transactionIdStore.setLastCommittedAndClosedTransactionId(lastRecoveredBatch.txId(), lastRecoveredBatch.checksum(), lastRecoveredBatch.timeWritten(), lastRecoveredTransactionPosition.getByteOffset(), lastRecoveredTransactionPosition.getLogVersion());
        } else {
            long lastClosedTransactionId = this.transactionIdStore.getLastClosedTransactionId();
            this.log.warn("Recovery detected that transaction logs tail can't be trusted. Resetting offset of last closed transaction to point to the last recoverable log position: " + positionAfterLastRecoveredTransaction);
            this.transactionIdStore.resetLastClosedTransaction(lastClosedTransactionId, positionAfterLastRecoveredTransaction.getLogVersion(), positionAfterLastRecoveredTransaction.getByteOffset(), -559063315, 0L);
        }
        this.logVersionRepository.setCurrentLogVersion(positionAfterLastRecoveredTransaction.getLogVersion());
        this.logVersionRepository.setCheckpointLogVersion(checkpointPosition.getLogVersion());
    }
}

