/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.management.impl;

import java.util.ArrayList;
import javax.management.NotCompliantMBeanException;
import org.neo4j.jmx.impl.ManagementBeanProvider;
import org.neo4j.jmx.impl.ManagementData;
import org.neo4j.jmx.impl.Neo4jMBean;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.management.XaManager;
import org.neo4j.management.XaResourceInfo;

public final class XaManagerBean
extends ManagementBeanProvider {
    public XaManagerBean() {
        super(XaManager.class);
    }

    protected Neo4jMBean createMBean(ManagementData management) throws NotCompliantMBeanException {
        return new XaManagerImpl(management);
    }

    protected Neo4jMBean createMXBean(ManagementData management) throws NotCompliantMBeanException {
        return new XaManagerImpl(management, true);
    }

    public static String toHexString(byte[] branchId) {
        StringBuilder result = new StringBuilder();
        for (byte part : branchId) {
            String chunk = Integer.toHexString(part);
            if (chunk.length() < 2) {
                result.append("0");
            }
            if (chunk.length() > 2) {
                result.append(chunk.substring(chunk.length() - 2));
                continue;
            }
            result.append(chunk);
        }
        return result.toString();
    }

    private static class XaManagerImpl
    extends Neo4jMBean
    implements XaManager {
        private final XaDataSourceManager datasourceMananger;

        XaManagerImpl(ManagementData management) throws NotCompliantMBeanException {
            super(management, new String[0]);
            this.datasourceMananger = management.getKernelData().graphDatabase().getXaDataSourceManager();
        }

        XaManagerImpl(ManagementData management, boolean isMxBean) {
            super(management, isMxBean, new String[0]);
            this.datasourceMananger = management.getKernelData().graphDatabase().getXaDataSourceManager();
        }

        @Override
        public XaResourceInfo[] getXaResources() {
            return XaManagerImpl.getXaResourcesImpl(this.datasourceMananger);
        }

        private static XaResourceInfo[] getXaResourcesImpl(XaDataSourceManager datasourceMananger) {
            ArrayList<XaResourceInfo> result = new ArrayList<XaResourceInfo>();
            for (XaDataSource datasource : datasourceMananger.getAllRegisteredDataSources()) {
                result.add(XaManagerImpl.createXaResourceInfo(datasource));
            }
            return result.toArray(new XaResourceInfo[result.size()]);
        }

        private static XaResourceInfo createXaResourceInfo(XaDataSource datasource) {
            return new XaResourceInfo(datasource.getName(), XaManagerBean.toHexString(datasource.getBranchId()), datasource.getLastCommittedTxId(), datasource.getCurrentLogVersion());
        }
    }
}

