/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.embedded.driver;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory;
import org.neo4j.ogm.classloader.ClassLoaderResolver;
import org.neo4j.ogm.config.DriverConfiguration;
import org.neo4j.ogm.driver.AbstractConfigurableDriver;
import org.neo4j.ogm.drivers.embedded.request.EmbeddedRequest;
import org.neo4j.ogm.drivers.embedded.transaction.EmbeddedTransaction;
import org.neo4j.ogm.exception.ConnectionException;
import org.neo4j.ogm.request.Request;
import org.neo4j.ogm.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedDriver
extends AbstractConfigurableDriver {
    private GraphDatabaseService graphDatabaseService;
    private final Logger logger = LoggerFactory.getLogger(EmbeddedDriver.class);

    public EmbeddedDriver() {
    }

    public EmbeddedDriver(DriverConfiguration driverConfiguration) {
        this.configure(driverConfiguration);
    }

    public EmbeddedDriver(GraphDatabaseService graphDatabaseService) {
        this.close();
        this.graphDatabaseService = graphDatabaseService;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                EmbeddedDriver.this.close();
            }
        });
    }

    public synchronized void configure(DriverConfiguration config) {
        this.close();
        super.configure(config);
        try {
            String fileStoreUri = config.getURI();
            if (fileStoreUri == null) {
                fileStoreUri = this.createTemporaryFileStore();
            } else {
                this.createPermanentFileStore(fileStoreUri);
            }
            File file = new File(new URI(fileStoreUri));
            if (!file.exists()) {
                throw new RuntimeException("Could not create/open filestore: " + fileStoreUri);
            }
            String haPropertiesFileName = config.getNeo4jHaPropertiesFile();
            if (haPropertiesFileName != null) {
                this.setHAGraphDatabase(file, ClassLoaderResolver.resolve().getResource(haPropertiesFileName));
            } else {
                this.setGraphDatabase(file);
            }
        }
        catch (Exception e) {
            throw new ConnectionException("Error connecting to embedded graph", (Throwable)e);
        }
    }

    private void setHAGraphDatabase(File file, URL propertiesFileURL) {
        this.graphDatabaseService = new HighlyAvailableGraphDatabaseFactory().newEmbeddedDatabaseBuilder(file).loadPropertiesFromURL(propertiesFileURL).newGraphDatabase();
    }

    private void setGraphDatabase(File file) {
        this.graphDatabaseService = new GraphDatabaseFactory().newEmbeddedDatabase(file);
    }

    public Transaction newTransaction(Transaction.Type type, String bookmark) {
        return new EmbeddedTransaction(this.transactionManager, this.nativeTransaction(), type);
    }

    public synchronized void close() {
        if (this.graphDatabaseService != null) {
            this.logger.info("Shutting down Embedded driver {} ", (Object)this.graphDatabaseService);
            this.graphDatabaseService.shutdown();
            this.graphDatabaseService = null;
        }
    }

    public GraphDatabaseService getGraphDatabaseService() {
        return this.graphDatabaseService;
    }

    public Request request() {
        return new EmbeddedRequest(this.graphDatabaseService, this.transactionManager);
    }

    private org.neo4j.graphdb.Transaction nativeTransaction() {
        org.neo4j.graphdb.Transaction nativeTransaction;
        Transaction tx = this.transactionManager.getCurrentTransaction();
        if (tx != null) {
            this.logger.debug("Using current transaction: {}", (Object)tx);
            nativeTransaction = ((EmbeddedTransaction)tx).getNativeTransaction();
        } else {
            this.logger.debug("No current transaction, starting a new one");
            nativeTransaction = this.graphDatabaseService.beginTx();
        }
        this.logger.debug("Native transaction: {}", (Object)nativeTransaction);
        return nativeTransaction;
    }

    private String createTemporaryFileStore() {
        try {
            Path path = Files.createTempDirectory("neo4j.db", new FileAttribute[0]);
            final File f = path.toFile();
            URI uri = f.toURI();
            final String fileStoreUri = uri.toString();
            this.logger.warn("Creating temporary file store: " + fileStoreUri);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    EmbeddedDriver.this.close();
                    try {
                        EmbeddedDriver.this.logger.warn("Deleting temporary file store: " + fileStoreUri);
                        FileUtils.deleteDirectory((File)f);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to delete temporary files in " + fileStoreUri);
                    }
                }
            });
            return fileStoreUri;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void createPermanentFileStore(String strPath) {
        try {
            URI uri = new URI(strPath);
            File file = new File(uri);
            if (!file.exists()) {
                Path graphDir = Files.createDirectories(Paths.get(uri.getRawPath(), new String[0]), new FileAttribute[0]);
                this.logger.warn("Creating new permanent file store: " + graphDir.toString());
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    EmbeddedDriver.this.close();
                }
            });
        }
        catch (FileAlreadyExistsException e) {
            this.logger.warn("Using existing permanent file store: " + strPath);
        }
        catch (IOException | URISyntaxException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

