/*
 * Decompiled with CFR 0.152.
 */
package net.grinder;

import java.io.Closeable;
import java.io.File;
import java.net.ServerSocket;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Timer;
import java.util.TimerTask;
import net.grinder.AgentDaemon;
import net.grinder.AgentUpdateHandler;
import net.grinder.common.GrinderProperties;
import net.grinder.common.processidentity.AgentIdentity;
import net.grinder.communication.Address;
import net.grinder.communication.ClientReceiver;
import net.grinder.communication.ClientSender;
import net.grinder.communication.CommunicationException;
import net.grinder.communication.ConnectionType;
import net.grinder.communication.Connector;
import net.grinder.communication.FanOutStreamSender;
import net.grinder.communication.Message;
import net.grinder.communication.MessageDispatchRegistry;
import net.grinder.communication.MessageDispatchSender;
import net.grinder.communication.MessagePump;
import net.grinder.communication.Receiver;
import net.grinder.communication.Sender;
import net.grinder.engine.agent.Agent;
import net.grinder.engine.agent.ConnectionAgentCommunicationProxy;
import net.grinder.engine.common.AgentControllerConnectorFactory;
import net.grinder.engine.communication.AgentControllerServerListener;
import net.grinder.engine.communication.AgentDownloadGrinderMessage;
import net.grinder.engine.communication.AgentUpdateGrinderMessage;
import net.grinder.engine.communication.ConnectionAgentCommunicationMessage;
import net.grinder.engine.communication.ConnectionAgentMessage;
import net.grinder.engine.communication.LogReportGrinderMessage;
import net.grinder.engine.controller.AgentControllerIdentityImplementation;
import net.grinder.message.console.AgentControllerProcessReportMessage;
import net.grinder.message.console.AgentControllerState;
import net.grinder.messages.agent.StartGrinderMessage;
import net.grinder.messages.console.AgentAddress;
import net.grinder.util.LogCompressUtils;
import net.grinder.util.NetworkUtils;
import net.grinder.util.thread.Condition;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.ngrinder.common.constants.AgentConstants;
import org.ngrinder.common.util.NoOp;
import org.ngrinder.common.util.Preconditions;
import org.ngrinder.infra.AgentConfig;
import org.ngrinder.monitor.collector.SystemDataCollector;
import org.ngrinder.monitor.controller.model.SystemDataModel;
import org.ngrinder.monitor.share.domain.SystemInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentController
implements Agent,
AgentConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"agent controller");
    private static final SystemDataModel emptySystemDataModel = new SystemDataModel();
    private final Condition m_eventSynchronization = new Condition();
    private final AgentConfig agentConfig;
    private final AgentControllerIdentityImplementation m_agentIdentity;
    private final AgentControllerServerListener m_agentControllerServerListener;
    private final AgentControllerConnectorFactory m_connectorFactory = new AgentControllerConnectorFactory(ConnectionType.AGENT);
    private final Condition m_eventSyncCondition;
    private final SystemDataCollector agentSystemDataCollector;
    private final String version;
    private volatile AgentControllerState m_state = AgentControllerState.STARTED;
    private int m_connectionPort = 0;
    private int retryCount = 0;
    private Timer m_timer;
    private FanOutStreamSender m_fanOutStreamSender;
    private AgentUpdateHandler agentUpdateHandler;
    private ConnectionAgentCommunicationProxy communicationProxy = ConnectionAgentCommunicationProxy.EMPTY;
    private ServerSocket connectionAgentSocket;

    public AgentController(Condition eventSyncCondition, AgentConfig agentConfig) {
        this.m_eventSyncCondition = eventSyncCondition;
        this.agentConfig = agentConfig;
        this.version = agentConfig.getInternalProperties().getProperty("ngrinder.version");
        this.m_agentControllerServerListener = new AgentControllerServerListener(this.m_eventSynchronization, LOGGER);
        this.m_agentIdentity = new AgentControllerIdentityImplementation(agentConfig.getAgentHostID(), agentConfig.getBroadcastIP());
        this.m_agentIdentity.setSubregion(agentConfig.getSubregion());
        String configuredOwner = agentConfig.getOwner();
        if (StringUtils.isEmpty((String)configuredOwner)) {
            String legacyOwner = this.getOwnerFromLegacyRegionConfig(agentConfig.getRegion());
            this.m_agentIdentity.setOwner(legacyOwner);
        } else {
            this.m_agentIdentity.setOwner(configuredOwner);
        }
        this.agentSystemDataCollector = new SystemDataCollector();
        this.agentSystemDataCollector.setAgentHome(agentConfig.getHome().getDirectory());
        this.agentSystemDataCollector.refresh();
    }

    private String getOwnerFromLegacyRegionConfig(String legacyRegionConfig) {
        if (legacyRegionConfig.contains("_owned_")) {
            String[] regionToken = legacyRegionConfig.split("_owned_");
            return regionToken.length > 1 ? regionToken[1] : "";
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Condition condition = this.m_eventSyncCondition;
        synchronized (condition) {
            this.m_eventSyncCondition.notifyAll();
        }
        StartGrinderMessage startMessage = null;
        ConsoleCommunication consoleCommunication = null;
        this.m_fanOutStreamSender = new FanOutStreamSender(3);
        this.m_timer = new Timer(false);
        AgentDaemon agentDaemon = new AgentDaemon(Preconditions.checkNotNull(this.agentConfig, "agent.conf should be provided before agent daemon start."));
        try {
            while (true) {
                block28: {
                    block29: {
                        block26: {
                            block27: {
                                if (consoleCommunication == null) {
                                    Connector connector;
                                    if (this.agentConfig.isConnectionMode()) {
                                        this.releaseConnectionAgentSocket();
                                        connector = this.m_connectorFactory.create(this.agentConfig.getConnectionAgentPort());
                                        this.occupyConnectionAgentSocket();
                                    } else {
                                        String controllerIP = NetworkUtils.getIP(this.agentConfig.getControllerHost());
                                        this.agentConfig.setControllerIP(controllerIP);
                                        connector = this.m_connectorFactory.create(controllerIP, this.agentConfig.getControllerPort());
                                    }
                                    try {
                                        consoleCommunication = new ConsoleCommunication(connector);
                                        consoleCommunication.start();
                                        LOGGER.info("Connected to agent controller server at {}", (Object)connector.getEndpointAsString());
                                    }
                                    catch (CommunicationException e) {
                                        LOGGER.error("Error while connecting to agent controller server at {}", (Object)connector.getEndpointAsString());
                                        this.m_connectionPort = 0;
                                        agentDaemon.shutdown();
                                        this.m_state = AgentControllerState.FINISHED;
                                        this.shutdownConsoleCommunication(consoleCommunication);
                                        this.m_timer.cancel();
                                        return;
                                    }
                                }
                                if (consoleCommunication == null || startMessage != null) break block26;
                                if (this.m_state != AgentControllerState.UPDATING) break block27;
                                this.m_agentControllerServerListener.waitForMessage();
                                break block28;
                            }
                            LOGGER.info("Waiting for agent controller server signal");
                            this.m_state = AgentControllerState.READY;
                            this.m_agentControllerServerListener.waitForMessage();
                            if (!this.m_agentControllerServerListener.received(1)) break block28;
                            startMessage = this.m_agentControllerServerListener.getLastStartGrinderMessage();
                            LOGGER.info("Agent start message is received from controller {}", (Object)startMessage);
                            break block29;
                        }
                        if (startMessage != null) {
                            this.m_agentIdentity.setNumber(startMessage.getAgentNumber());
                        }
                    }
                    if (((StartGrinderMessage)Preconditions.checkNotNull(startMessage)).getProperties() == null) continue;
                }
                if (startMessage != null) {
                    ConsoleCommunication conCom = consoleCommunication;
                    String testId = startMessage.getProperties().getProperty("grinder.test.id", "unknown");
                    LOGGER.info("Starting agent... for {}", (Object)testId);
                    this.m_state = AgentControllerState.BUSY;
                    this.m_connectionPort = startMessage.getProperties().getInt("grinder.consolePort", 0);
                    GrinderProperties grinderProperties = startMessage.getProperties();
                    if (this.agentConfig.isConnectionMode()) {
                        int localConnectionPort = NetworkUtils.getFreePort();
                        grinderProperties.setInt("grinder.consolePort", localConnectionPort);
                        this.communicationProxy = new ConnectionAgentCommunicationProxy(localConnectionPort, this.agentConfig.getConnectionAgentPort(), LOGGER, () -> conCom.sendMessage(new ConnectionAgentCommunicationMessage(this.m_connectionPort, this.m_agentIdentity.getIp(), this.agentConfig.getConnectionAgentPort())));
                        this.releaseConnectionAgentSocket();
                        this.communicationProxy.start();
                    }
                    agentDaemon.run(grinderProperties);
                    agentDaemon.resetListeners();
                    agentDaemon.addListener(() -> {
                        LOGGER.info("Send log for {}", (Object)testId);
                        this.sendLog(conCom, testId);
                        this.m_state = AgentControllerState.READY;
                        this.m_connectionPort = 0;
                        this.communicationProxy.shutdown();
                        this.communicationProxy = ConnectionAgentCommunicationProxy.EMPTY;
                        this.occupyConnectionAgentSocket();
                    });
                }
                this.m_agentControllerServerListener.discardMessages(1);
                if (!this.m_agentControllerServerListener.received(31)) {
                    LOGGER.info("Agent is started. Waiting for agent controller signal");
                    this.m_agentControllerServerListener.waitForMessage();
                }
                if (this.m_agentControllerServerListener.received(1)) {
                    startMessage = this.m_agentControllerServerListener.getLastStartGrinderMessage();
                    continue;
                }
                if (this.m_agentControllerServerListener.received(4)) {
                    agentDaemon.shutdown();
                    startMessage = null;
                    this.m_connectionPort = 0;
                    this.m_agentControllerServerListener.discardMessages(4);
                    continue;
                }
                if (this.m_agentControllerServerListener.received(8)) {
                    this.m_connectionPort = 0;
                    break;
                }
                if (this.m_agentControllerServerListener.received(16)) {
                    startMessage = null;
                    this.m_connectionPort = 0;
                    this.m_state = AgentControllerState.UPDATING;
                    AgentUpdateGrinderMessage message = this.m_agentControllerServerListener.getLastAgentUpdateGrinderMessage();
                    this.m_agentControllerServerListener.discardMessages(16);
                    AgentDownloadGrinderMessage agentDownloadGrinderMessage = new AgentDownloadGrinderMessage(message.getVersion());
                    try {
                        if (this.agentUpdateHandler == null && message.getNext() == 0) {
                            IOUtils.closeQuietly((Closeable)this.agentUpdateHandler);
                            this.agentUpdateHandler = new AgentUpdateHandler(this.agentConfig, message);
                        } else {
                            if (this.agentUpdateHandler == null) throw new CommunicationException("Error while getting the agent package from controller");
                            if (message.isValid()) {
                                this.retryCount = 0;
                                this.agentUpdateHandler.update(message);
                                agentDownloadGrinderMessage.setNext(message.getNext());
                            } else {
                                if (this.retryCount > AgentDownloadGrinderMessage.MAX_RETRY_COUNT) throw new CommunicationException("Error while getting the agent package from controller");
                                ++this.retryCount;
                                agentDownloadGrinderMessage.setNext(message.getOffset());
                            }
                        }
                        if (consoleCommunication == null) break;
                        consoleCommunication.sendMessage((Message)agentDownloadGrinderMessage);
                    }
                    catch (IllegalArgumentException ex) {
                        IOUtils.closeQuietly((Closeable)this.agentUpdateHandler);
                        this.agentUpdateHandler = null;
                        this.retryCount = 0;
                        LOGGER.info("same or old agent version {} is sent for update. skip this.", (Object)message.getVersion());
                        this.m_state = AgentControllerState.READY;
                    }
                    catch (Exception e) {
                        this.retryCount = 0;
                        IOUtils.closeQuietly((Closeable)this.agentUpdateHandler);
                        this.agentUpdateHandler = null;
                        LOGGER.error("While updating agent, the exception occurred.", (Throwable)e);
                        this.m_state = AgentControllerState.READY;
                    }
                    continue;
                }
                startMessage = null;
            }
            this.m_connectionPort = 0;
            agentDaemon.shutdown();
            this.m_state = AgentControllerState.FINISHED;
            this.shutdownConsoleCommunication(consoleCommunication);
            this.m_timer.cancel();
            return;
        }
        catch (Throwable throwable) {
            this.m_connectionPort = 0;
            agentDaemon.shutdown();
            this.m_state = AgentControllerState.FINISHED;
            this.shutdownConsoleCommunication(consoleCommunication);
            this.m_timer.cancel();
            throw throwable;
        }
    }

    private void sendLog(ConsoleCommunication consoleCommunication, String testId) {
        File logFolder = new File(this.agentConfig.getHome().getLogDirectory(), testId);
        if (!logFolder.exists()) {
            return;
        }
        Object[] logFiles = logFolder.listFiles((dir, name) -> name.endsWith(".log"));
        if (logFiles == null || ArrayUtils.isEmpty((Object[])logFiles)) {
            LOGGER.error("No log exists under {}", (Object)logFolder.getAbsolutePath());
            return;
        }
        Arrays.sort(logFiles);
        if (!this.agentConfig.getAgentProperties().getPropertyBoolean("agent.all_logs")) {
            logFiles = new File[]{logFiles[0]};
        }
        byte[] compressedLog = LogCompressUtils.compress((File[])logFiles, Charset.defaultCharset(), StandardCharsets.UTF_8);
        consoleCommunication.sendMessage((Message)new LogReportGrinderMessage(testId, compressedLog, new AgentAddress((AgentIdentity)this.m_agentIdentity)));
        if (!this.agentConfig.getAgentProperties().getPropertyBoolean("agent.keep_logs")) {
            LOGGER.info("Clean up the perftest logs");
            FileUtils.deleteQuietly((File)logFolder);
        }
    }

    private void shutdownConsoleCommunication(ConsoleCommunication consoleCommunication) {
        this.sendCurrentState(consoleCommunication);
        if (consoleCommunication != null) {
            consoleCommunication.shutdown();
            consoleCommunication = null;
        }
        this.m_agentControllerServerListener.discardMessages(31);
    }

    private void sendCurrentState(ConsoleCommunication consoleCommunication) {
        if (consoleCommunication != null) {
            try {
                consoleCommunication.sendCurrentState();
            }
            catch (RuntimeException e) {
                LOGGER.error("Error while sending current state : {}.", (Object)e.getMessage());
                LOGGER.debug("The error detail is ", (Throwable)e);
            }
        }
    }

    private void occupyConnectionAgentSocket() {
        try {
            this.connectionAgentSocket = new ServerSocket(this.agentConfig.getConnectionAgentPort());
        }
        catch (Exception e) {
            NoOp.noOp();
        }
    }

    private void releaseConnectionAgentSocket() {
        try {
            if (this.connectionAgentSocket != null) {
                this.connectionAgentSocket.close();
            }
        }
        catch (Exception e) {
            NoOp.noOp();
        }
    }

    public void shutdown() {
        if (this.m_timer != null) {
            this.m_timer.cancel();
        }
        if (this.m_fanOutStreamSender != null) {
            this.m_fanOutStreamSender.shutdown();
        }
        this.m_agentControllerServerListener.shutdown();
        LOGGER.info("Agent controller shuts down");
    }

    public SystemDataModel getSystemDataModel() {
        try {
            SystemInfo systemInfo = this.agentSystemDataCollector.execute();
            return new SystemDataModel(systemInfo, this.version);
        }
        catch (Exception e) {
            LOGGER.error("Error while getting system data model : {} ", (Object)e.getMessage());
            LOGGER.debug("The error detail is ", (Throwable)e);
            return emptySystemDataModel;
        }
    }

    public AgentConfig getAgentConfig() {
        return this.agentConfig;
    }

    public final class ConsoleCommunication {
        private final ClientSender m_sender;
        private final TimerTask m_reportRunningTask;
        private final MessagePump m_messagePump;

        public ConsoleCommunication(Connector connector) throws CommunicationException {
            ClientReceiver receiver = ClientReceiver.connect((Connector)connector, (Address)new AgentAddress((AgentIdentity)AgentController.this.m_agentIdentity));
            this.m_sender = ClientSender.connect((ClientReceiver)receiver);
            this.m_sender.send((Message)new AgentControllerProcessReportMessage(AgentControllerState.STARTED, AgentController.this.getSystemDataModel(), AgentController.this.m_connectionPort, AgentController.this.version));
            MessageDispatchSender messageDispatcher = new MessageDispatchSender();
            AgentController.this.m_agentControllerServerListener.registerMessageHandlers((MessageDispatchRegistry)messageDispatcher);
            this.m_messagePump = new MessagePump((Receiver)receiver, (Sender)messageDispatcher, 1);
            this.m_reportRunningTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        ConsoleCommunication.this.sendCurrentState();
                    }
                    catch (RuntimeException e) {
                        this.cancel();
                        LOGGER.error("Error while sending current state:" + e.getMessage());
                        LOGGER.debug("The error detail is", (Throwable)e);
                    }
                }
            };
            if (AgentController.this.agentConfig.isConnectionMode()) {
                this.m_sender.send((Message)new ConnectionAgentMessage(AgentController.this.m_agentIdentity.getIp(), AgentController.this.agentConfig.getAgentHostID(), AgentController.this.agentConfig.getSubregion(), AgentController.this.agentConfig.getConnectionAgentPort()));
            }
        }

        public void sendMessage(Message message) {
            try {
                this.m_sender.send(message);
            }
            catch (CommunicationException e) {
                LOGGER.error("{}. This error is not critical if it doesn't occur much.", (Object)e.getMessage());
            }
        }

        public void sendCurrentState() {
            this.sendMessage((Message)new AgentControllerProcessReportMessage(AgentController.this.m_state, AgentController.this.getSystemDataModel(), AgentController.this.m_connectionPort, AgentController.this.version));
        }

        public void start() {
            this.m_messagePump.start();
            AgentController.this.m_timer.schedule(this.m_reportRunningTask, 0L, 990L);
        }

        public void shutdown() {
            this.m_reportRunningTask.cancel();
            try {
                this.m_sender.send((Message)new AgentControllerProcessReportMessage(AgentControllerState.FINISHED, null, 0, AgentController.this.version));
            }
            catch (CommunicationException e) {
                NoOp.noOp();
            }
            finally {
                this.m_messagePump.shutdown();
            }
        }
    }
}

