/*
 * Decompiled with CFR 0.152.
 */
package net.grinder;

import java.util.Timer;
import net.grinder.console.common.ErrorHandler;
import net.grinder.console.common.ErrorQueue;
import net.grinder.console.common.Resources;
import net.grinder.console.communication.AgentProcessControlImplementation;
import net.grinder.console.communication.ConsoleCommunication;
import net.grinder.console.communication.ConsoleCommunicationImplementationEx;
import net.grinder.console.model.ConsoleCommunicationSetting;
import net.grinder.console.model.ConsoleProperties;
import net.grinder.engine.console.ErrorHandlerImplementation;
import net.grinder.util.StandardTimeAuthority;
import net.grinder.util.thread.Condition;
import org.ngrinder.common.util.ExceptionUtils;
import org.ngrinder.common.util.NoOp;
import org.picocontainer.ComponentFactory;
import org.picocontainer.DefaultPicoContainer;
import org.picocontainer.behaviors.Caching;
import org.slf4j.Logger;

public class AgentControllerServer {
    private final DefaultPicoContainer m_container;
    private final Timer m_timer;
    private final Condition m_eventSyncCondition;
    private boolean m_shutdown = false;

    public AgentControllerServer(Resources resources, Logger logger, ConsoleProperties properties, Condition eventSyncCondition, ConsoleCommunicationSetting consoleCommunicationSetting) {
        this.m_eventSyncCondition = eventSyncCondition;
        this.m_container = new DefaultPicoContainer((ComponentFactory)new Caching());
        this.m_container.addComponent((Object)logger);
        this.m_container.addComponent((Object)resources);
        this.m_container.addComponent((Object)properties);
        this.m_container.addComponent((Object)new StandardTimeAuthority());
        this.m_container.addComponent((Object)consoleCommunicationSetting);
        this.m_container.addComponent(ConsoleCommunicationImplementationEx.class);
        this.m_container.addComponent(AgentProcessControlImplementation.class);
        this.m_timer = new Timer(true);
        this.m_container.addComponent((Object)this.m_timer);
        this.m_container.addComponent(ErrorQueue.class);
        ErrorQueue errorQueue = (ErrorQueue)this.m_container.getComponent(ErrorQueue.class);
        errorQueue.setErrorHandler((ErrorHandler)new ErrorHandlerImplementation(logger));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.m_shutdown) {
            throw ExceptionUtils.processException("The console can not be run because it's already shutdown");
        }
        this.m_container.start();
        this.m_container.getComponent(AgentProcessControlImplementation.class);
        ConsoleCommunication communication = (ConsoleCommunication)this.m_container.getComponent(ConsoleCommunication.class);
        Condition condition = this.m_eventSyncCondition;
        synchronized (condition) {
            this.m_eventSyncCondition.notifyAll();
        }
        while (communication.processOneMessage()) {
            NoOp.noOp();
        }
    }

    public void shutdown() {
        this.m_shutdown = true;
        ((ConsoleCommunication)this.m_container.getComponent(ConsoleCommunication.class)).shutdown();
        try {
            this.m_timer.cancel();
        }
        catch (Exception e) {
            NoOp.noOp();
        }
        if (this.m_container.getLifecycleState().isStarted()) {
            this.m_container.stop();
        }
    }

    public <T> T getComponent(Class<T> componentType) {
        return (T)this.m_container.getComponent(componentType);
    }
}

