/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.communication;

import net.grinder.communication.Message;
import org.ngrinder.common.util.CRC32ChecksumUtils;

public class AgentUpdateGrinderMessage
implements Message {
    private final String version;
    private final byte[] binary;
    private final int offset;
    private int next;
    private final long checksum;

    public AgentUpdateGrinderMessage(String version, byte[] binary, int offset, int next, long checksum) {
        this.version = version;
        this.binary = binary;
        this.offset = offset;
        this.next = next;
        this.checksum = checksum;
    }

    public static AgentUpdateGrinderMessage getNullAgentUpdateGrinderMessage(String version) {
        return new AgentUpdateGrinderMessage(version, new byte[0], 0, -1, -1L);
    }

    public static AgentUpdateGrinderMessage getStartAgentUpdateGrinderMessage(String version) {
        return new AgentUpdateGrinderMessage(version, new byte[0], 0, 0, 0L);
    }

    public String getVersion() {
        return this.version;
    }

    public int getOffset() {
        return this.offset;
    }

    public long getChecksum() {
        return this.checksum;
    }

    public byte[] getBinary() {
        return this.binary;
    }

    public int getNext() {
        return this.next;
    }

    public boolean isValid() {
        return this.next >= 0 && this.getChecksum() == CRC32ChecksumUtils.getCRC32Checksum(this.getBinary());
    }
}

