/*
 * Decompiled with CFR 0.152.
 */
package org.ngrinder;

import com.beust.jcommander.JCommander;
import java.io.IOException;
import java.io.InputStream;
import java.security.Security;
import java.util.List;
import java.util.Properties;
import net.grinder.AgentControllerDaemon;
import net.grinder.util.NetworkUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.ngrinder.NGrinderAgentStarterParam;
import org.ngrinder.common.constants.AgentConstants;
import org.ngrinder.common.constants.CommonConstants;
import org.ngrinder.common.util.SystemInfoUtils;
import org.ngrinder.infra.AgentConfig;
import org.ngrinder.monitor.agent.MonitorServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.software.os.OSProcess;

public class NGrinderAgentStarter
implements AgentConstants,
CommonConstants {
    private static final Logger LOG = LoggerFactory.getLogger((String)"starter");
    private static final String NETWORK_ADDRESS_CACHE_TTL_SECOND = "20";
    private AgentConfig agentConfig;
    private AgentControllerDaemon agentController;
    private static NGrinderAgentStarterParam.NGrinderModeParam modeParam;

    public void init() {
        this.agentConfig = this.createAgentConfig();
    }

    protected AgentConfig createAgentConfig() {
        AgentConfig agentConfig = new AgentConfig();
        agentConfig.init();
        return agentConfig;
    }

    public String getStartMode() {
        return this.agentConfig.getCommonProperties().getProperty("common.start_mode");
    }

    public String getVersion() {
        return this.agentConfig.getInternalProperties().getProperty("ngrinder.version");
    }

    public void startMonitor() {
        this.printLog("***************************************************", new Object[0]);
        this.printLog("* Start nGrinder Monitor... ", new Object[0]);
        this.printLog("***************************************************", new Object[0]);
        try {
            MonitorServer.getInstance().init(this.agentConfig);
            MonitorServer.getInstance().start();
        }
        catch (Exception e) {
            LOG.error("ERROR: {}", (Object)e.getMessage());
            this.printHelpAndExit("Error while starting Monitor", e);
        }
    }

    void stopMonitor() {
        MonitorServer.getInstance().stop();
    }

    public void startAgent() {
        boolean serverMode;
        this.printLog("***************************************************", new Object[0]);
        this.printLog("   Start nGrinder Agent ...", new Object[0]);
        this.printLog("***************************************************", new Object[0]);
        if (StringUtils.isEmpty((String)System.getenv("JAVA_HOME"))) {
            this.printLog("Hey!! JAVA_HOME env var was not provided. Please provide JAVA_HOME env var before running agent.Otherwise you can not execute the agent in the security mode.", new Object[0]);
        }
        if (!(serverMode = this.agentConfig.isServerMode())) {
            this.printLog("JVM server mode is disabled.", new Object[0]);
        }
        if (this.agentConfig.isConnectionMode()) {
            LOG.info("waiting for connection on {}:{}", (Object)this.agentConfig.getBroadcastIP(), (Object)this.agentConfig.getConnectionAgentPort());
        } else {
            String controllerIP = NetworkUtils.getIP(this.agentConfig.getControllerHost());
            this.agentConfig.setControllerIP(controllerIP);
            LOG.info("connecting to controller {}:{}", (Object)controllerIP, (Object)this.agentConfig.getControllerPort());
        }
        try {
            this.agentController = new AgentControllerDaemon(this.agentConfig);
            this.agentController.run();
        }
        catch (Exception e) {
            LOG.error("Error while starting Agent", (Throwable)e);
            this.printHelpAndExit("Error while starting Agent", e);
        }
    }

    private void printLog(String s, Object ... args) {
        if (!this.agentConfig.isSilentMode()) {
            LOG.info(s, args);
        }
    }

    void stopAgent() {
        LOG.info("Stop nGrinder agent!");
        this.agentController.shutdown();
    }

    public static void main(String[] args) {
        NGrinderAgentStarter starter = new NGrinderAgentStarter();
        NGrinderAgentStarterParam param = new NGrinderAgentStarterParam();
        JCommander commander = new JCommander((Object)param);
        commander.setProgramName("ngrinder-agent");
        commander.setAcceptUnknownOptions(true);
        try {
            commander.parse(args);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            return;
        }
        List unknownOptions = commander.getUnknownOptions();
        modeParam = param.getModeParam();
        modeParam.parse(unknownOptions.toArray(new String[0]));
        if (NGrinderAgentStarter.modeParam.version != null) {
            LOG.info("nGrinder v" + NGrinderAgentStarter.getStaticVersion());
            return;
        }
        if (NGrinderAgentStarter.modeParam.help != null) {
            modeParam.usage();
            return;
        }
        System.getProperties().putAll(NGrinderAgentStarter.modeParam.params);
        starter.init();
        String startMode = modeParam.name();
        if ("stop".equalsIgnoreCase(param.command)) {
            starter.stopProcess(startMode);
            LOG.info("Stop the " + startMode);
            return;
        }
        starter.checkDuplicatedRun(startMode);
        Security.setProperty("networkaddress.cache.ttl", NETWORK_ADDRESS_CACHE_TTL_SECOND);
        if (startMode.equalsIgnoreCase("agent")) {
            starter.startAgent();
        } else if (startMode.equalsIgnoreCase("monitor")) {
            starter.startMonitor();
        } else {
            NGrinderAgentStarter.staticPrintHelpAndExit("Invalid agent.conf, '--mode' must be set as 'monitor' or 'agent'.");
        }
    }

    private static String getStaticVersion() {
        InputStream inputStream = null;
        Properties properties = new Properties();
        try {
            inputStream = NGrinderAgentStarter.class.getResourceAsStream("/internal.properties");
            properties.load(inputStream);
        }
        catch (IOException iOException) {
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return properties.getProperty("ngrinder.version", "UNKNOWN");
    }

    protected void stopProcess(String mode) {
        int pid;
        OSProcess process;
        String pidProperty = this.agentConfig.getAgentPidProperties(mode);
        if (StringUtils.isBlank((String)pidProperty)) {
            this.printMessageAndExit(String.format("Error occurred while terminating %s process. (empty pid)", mode));
        }
        if ((process = SystemInfoUtils.getProcess(pid = Integer.parseInt(pidProperty))) == null) {
            this.printMessageAndExit(String.format("Error occurred while terminating %s process. (pid: %s is not running)", mode, pid));
        }
        SystemInfoUtils.killProcess(pid);
        process = SystemInfoUtils.getProcess(pid);
        if (process != null) {
            this.printMessageAndExit(String.format("Error occurred while terminating %s process.\nIt can be already stopped or you may not have the permission.\nIf everything is OK. Please stop it manually.", mode));
        }
        this.agentConfig.updateAgentPidProperties(mode);
    }

    public void checkDuplicatedRun(String startMode) {
        String existingPid = this.agentConfig.getAgentPidProperties(startMode);
        if (StringUtils.isNotEmpty((String)existingPid)) {
            OSProcess process = SystemInfoUtils.getProcess(Integer.parseInt(existingPid));
            if (process != null) {
                this.printHelpAndExit("Currently " + startMode + " is running with pid " + existingPid + ". Please stop it before run");
            }
            this.agentConfig.updateAgentPidProperties(startMode);
        }
        this.agentConfig.saveAgentPidProperties(String.valueOf(SystemInfoUtils.getPid()), startMode);
    }

    protected void printHelpAndExit(String message) {
        NGrinderAgentStarter.staticPrintHelpAndExit(message);
    }

    protected void printHelpAndExit(String message, Exception e) {
        NGrinderAgentStarter.staticPrintHelpAndExit(message, e);
    }

    private static void staticPrintHelpAndExit(String message) {
        NGrinderAgentStarter.staticPrintHelpAndExit(message, null);
    }

    private static void staticPrintHelpAndExit(String message, Exception e) {
        if (e == null) {
            LOG.error(message);
        } else {
            LOG.error(message, (Throwable)e);
        }
        if (modeParam != null) {
            modeParam.usage();
        }
        System.exit(-1);
    }

    private void printMessageAndExit(String message) {
        LOG.error(message);
        System.exit(-1);
    }
}

