/*
 * Decompiled with CFR 0.152.
 */
package org.ngrinder.common.util;

import java.util.List;
import org.ngrinder.common.exception.NGrinderRuntimeException;
import org.ngrinder.common.util.CollectionUtils;

public abstract class ExceptionUtils {
    private static final String[] NON_NGRINDER_PACKAGE = "org.springframework.,javax.,org.apache.catalina.,sun.,net.sf.,java.,org.ngrinder.common.exception.NGrinderRuntimeException,com.springsource.,org.apache.coyote.,org.apache.tomact.,org.ngrinder.common.util.ExceptionUtils.".split("(\\s|,)+");

    public static NGrinderRuntimeException processException(Throwable t) {
        if (t instanceof NGrinderRuntimeException) {
            throw (NGrinderRuntimeException)ExceptionUtils.sanitize(t);
        }
        throw new NGrinderRuntimeException(ExceptionUtils.sanitize(t), true);
    }

    public static NGrinderRuntimeException processException(String message) {
        throw ExceptionUtils.processException(new NGrinderRuntimeException(message));
    }

    public static NGrinderRuntimeException processException(String message, Throwable t) {
        if (t instanceof NGrinderRuntimeException) {
            throw (NGrinderRuntimeException)ExceptionUtils.sanitize(t);
        }
        throw new NGrinderRuntimeException(message, ExceptionUtils.sanitize(t), true);
    }

    public static Throwable sanitize(Throwable throwable) {
        if (throwable instanceof NGrinderRuntimeException && ((NGrinderRuntimeException)throwable).isSanitized()) {
            return throwable;
        }
        for (Throwable t = throwable; t != null; t = t.getCause()) {
            StackTraceElement[] trace = t.getStackTrace();
            List newTrace = CollectionUtils.newArrayList();
            for (StackTraceElement stackTraceElement : trace) {
                if (!ExceptionUtils.isApplicationClass(stackTraceElement.getClassName())) continue;
                newTrace.add(stackTraceElement);
            }
            StackTraceElement[] clean = new StackTraceElement[newTrace.size()];
            newTrace.toArray(clean);
            t.setStackTrace(clean);
        }
        if (throwable instanceof NGrinderRuntimeException) {
            ((NGrinderRuntimeException)throwable).setSanitized(true);
        }
        return throwable;
    }

    private static boolean isApplicationClass(String className) {
        for (String each : ExceptionUtils.getUninterestingPackages()) {
            if (!className.startsWith(each)) continue;
            return false;
        }
        return true;
    }

    protected static String[] getUninterestingPackages() {
        return NON_NGRINDER_PACKAGE;
    }
}

