/*
 * Decompiled with CFR 0.152.
 */
package org.ngrinder.common.util;

import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.picocontainer.annotations.Nullable;

public final class Preconditions {
    private static final int DEFAULT_16 = 16;

    private Preconditions() {
    }

    public static void checkArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean expression, @Nullable Object errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
    }

    public static void checkArgument(boolean expression, @Nullable String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static <T> T[] checkNotEmpty(T[] expression, @Nullable String errorMessageTemplate, Object ... errorMessageArgs) {
        if (expression == null || expression.length == 0) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, errorMessageArgs));
        }
        return expression;
    }

    public static void checkState(boolean expression) {
        if (!expression) {
            throw new IllegalStateException();
        }
    }

    public static void checkState(boolean expression, @Nullable Object errorMessage) {
        if (!expression) {
            throw new IllegalStateException(String.valueOf(errorMessage));
        }
    }

    public static void checkState(boolean expression, @Nullable String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static String checkNotEmpty(String reference) {
        if (StringUtils.isEmpty((String)reference)) {
            throw new IllegalArgumentException();
        }
        return reference;
    }

    public static String checkNotEmpty(String reference, String errorMsg) {
        if (StringUtils.isEmpty((String)reference)) {
            throw new IllegalArgumentException(errorMsg);
        }
        return reference;
    }

    public static Integer checkNotZero(Integer reference, String errorMsg) {
        if (reference == null || reference == 0) {
            throw new IllegalArgumentException(errorMsg);
        }
        return reference;
    }

    public static Long checkNotZero(Long reference, String errorMsg) {
        if (reference == null || reference == 0L) {
            throw new IllegalArgumentException(errorMsg);
        }
        return reference;
    }

    public static void checkTrue(boolean condition, String errorMsg) {
        if (!condition) {
            throw new IllegalArgumentException(errorMsg);
        }
    }

    public static <T> T checkExist(T reference, String message, Object ... args) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format(message, args));
        }
        return reference;
    }

    public static <T> T checkNull(T reference, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (reference != null) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, errorMessageArgs));
        }
        return reference;
    }

    public static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new IllegalArgumentException();
        }
        return reference;
    }

    public static <T> T checkNotNull(T reference, @Nullable Object errorMessage) {
        if (reference == null) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
        return reference;
    }

    public static <T> T checkNotNull(T reference, @Nullable String errorMessageTemplate, Object ... errorMessageArgs) {
        if (reference == null) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, errorMessageArgs));
        }
        return reference;
    }

    public static int checkElementIndex(int index, int size) {
        return Preconditions.checkElementIndex(index, size, "index");
    }

    public static int checkElementIndex(int index, int size, @Nullable String desc) {
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException(Preconditions.buildBadElementIndexMessage(index, size, desc));
        }
        return index;
    }

    private static String buildBadElementIndexMessage(int index, int size, String desc) {
        if (index < 0) {
            return Preconditions.format("%s (%s) must not be negative", desc, index);
        }
        if (size < 0) {
            throw new IllegalArgumentException("negative size: " + size);
        }
        return Preconditions.format("%s (%s) must be less than size (%s)", desc, index, size);
    }

    public static int checkPositionIndex(int index, int size) {
        return Preconditions.checkPositionIndex(index, size, "index");
    }

    public static int checkPositionIndex(int index, int size, @Nullable String desc) {
        if (index < 0 || index > size) {
            throw new IndexOutOfBoundsException(Preconditions.buildBadPositionIndexMessage(index, size, desc));
        }
        return index;
    }

    private static String buildBadPositionIndexMessage(int index, int size, String desc) {
        if (index < 0) {
            return Preconditions.format("%s (%s) must not be negative", desc, index);
        }
        if (size < 0) {
            throw new IllegalArgumentException("negative size: " + size);
        }
        return Preconditions.format("%s (%s) must not be greater than size (%s)", desc, index, size);
    }

    public static void checkPositionIndexes(int start, int end, int size) {
        if (start < 0 || end < start || end > size) {
            throw new IndexOutOfBoundsException(Preconditions.buildBadPositionIndexesMessage(start, end, size));
        }
    }

    private static String buildBadPositionIndexesMessage(int start, int end, int size) {
        if (start < 0 || start > size) {
            return Preconditions.buildBadPositionIndexMessage(start, size, "start index");
        }
        if (end < 0 || end > size) {
            return Preconditions.buildBadPositionIndexMessage(end, size, "end index");
        }
        return Preconditions.format("end index (%s) must not be less than start index (%s)", end, start);
    }

    static String format(String template, Object ... args) {
        int placeholderStart;
        template = String.valueOf(template);
        StringBuilder builder = new StringBuilder(template.length() + 16 * args.length);
        int templateStart = 0;
        int i = 0;
        while (i < args.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template, templateStart, placeholderStart);
            builder.append(args[i++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template.substring(templateStart));
        if (i < args.length) {
            builder.append(" [");
            builder.append(args[i++]);
            while (i < args.length) {
                builder.append(", ");
                builder.append(args[i++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }

    public static URL checkValidURL(String url) {
        try {
            return new URL(url);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Url " + url + "should be valid", e);
        }
    }
}

